/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.networking.EventLoopGroup;
import com.hazelcast.internal.networking.nio.NioEventLoopGroup;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;

public class NetworkingPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.networking.seconds", 0, TimeUnit.SECONDS);
    private static final double HUNDRED = 100.0;
    private final NioEventLoopGroup eventLoopGroup;
    private final long periodMillis;

    public NetworkingPlugin(NodeEngineImpl nodeEngine) {
        this(nodeEngine.getProperties(), NetworkingPlugin.getThreadingModel(nodeEngine), nodeEngine.getLogger(NetworkingPlugin.class));
    }

    public NetworkingPlugin(HazelcastProperties properties, EventLoopGroup eventLoopGroup, ILogger logger) {
        super(logger);
        this.eventLoopGroup = eventLoopGroup instanceof NioEventLoopGroup ? (NioEventLoopGroup)eventLoopGroup : null;
        this.periodMillis = this.eventLoopGroup == null ? 0L : properties.getMillis(PERIOD_SECONDS);
    }

    private static EventLoopGroup getThreadingModel(NodeEngineImpl nodeEngine) {
        ConnectionManager connectionManager = nodeEngine.getNode().getConnectionManager();
        if (!(connectionManager instanceof TcpIpConnectionManager)) {
            return null;
        }
        return ((TcpIpConnectionManager)connectionManager).getEventLoopGroup();
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active: period-millis:" + this.periodMillis);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        writer.startSection("Networking");
        writer.startSection("InputThreads");
        this.render(writer, this.eventLoopGroup.getInputThreads());
        writer.endSection();
        writer.startSection("OutputThreads");
        this.render(writer, this.eventLoopGroup.getOutputThreads());
        writer.endSection();
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, NioThread[] threads) {
        if (threads == null) {
            return;
        }
        long totalPriorityFramesReceived = 0L;
        long totalFramesReceived = 0L;
        long totalBytesReceived = 0L;
        long totalEvents = 0L;
        long totalTaskCount = 0L;
        long totalHandleCount = 0L;
        for (NioThread thread : threads) {
            totalBytesReceived += thread.bytesTransceived();
            totalFramesReceived += thread.framesTransceived();
            totalPriorityFramesReceived += thread.priorityFramesTransceived();
            totalEvents += thread.eventCount();
            totalTaskCount += thread.completedTaskCount();
            totalHandleCount += thread.handleCount();
        }
        for (NioThread thread : threads) {
            writer.startSection(thread.getName());
            writer.writeKeyValueEntry("frames-percentage", this.toPercentage(thread.framesTransceived(), totalFramesReceived));
            writer.writeKeyValueEntry("frames", thread.framesTransceived());
            writer.writeKeyValueEntry("priority-frames-percentage", this.toPercentage(thread.priorityFramesTransceived(), totalPriorityFramesReceived));
            writer.writeKeyValueEntry("priority-frames", thread.priorityFramesTransceived());
            writer.writeKeyValueEntry("bytes-percentage", this.toPercentage(thread.bytesTransceived(), totalBytesReceived));
            writer.writeKeyValueEntry("bytes", thread.bytesTransceived());
            writer.writeKeyValueEntry("events-percentage", this.toPercentage(thread.eventCount(), totalEvents));
            writer.writeKeyValueEntry("events", thread.eventCount());
            writer.writeKeyValueEntry("handle-count-percentage", this.toPercentage(thread.handleCount(), totalHandleCount));
            writer.writeKeyValueEntry("handle-count", thread.handleCount());
            writer.writeKeyValueEntry("tasks-percentage", this.toPercentage(thread.completedTaskCount(), totalTaskCount));
            writer.writeKeyValueEntry("tasks", thread.completedTaskCount());
            writer.endSection();
        }
    }

    private String toPercentage(long amount, long total) {
        double percentage = 100.0 * (double)amount / (double)total;
        return String.format("%1$,.2f", percentage) + " %";
    }
}

