/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.invalidation;

import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.MinimalPartitionService;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetectorImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.TaskScheduler;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Preconditions;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class RepairingTask
implements Runnable {
    static final HazelcastProperty MAX_TOLERATED_MISS_COUNT = new HazelcastProperty("hazelcast.invalidation.max.tolerated.miss.count", 10);
    static final HazelcastProperty RECONCILIATION_INTERVAL_SECONDS = new HazelcastProperty("hazelcast.invalidation.reconciliation.interval.seconds", 60, TimeUnit.SECONDS);
    static final long MIN_RECONCILIATION_INTERVAL_SECONDS = 30L;
    static final long GET_UUID_TASK_SCHEDULE_MILLIS = 500L;
    static final long HALF_MINUTE_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    final long reconciliationIntervalNanos;
    final int maxToleratedMissCount;
    private final ConcurrentMap<String, RepairingHandler> handlers = new ConcurrentHashMap<String, RepairingHandler>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final MetaDataFetcher metaDataFetcher;
    private final TaskScheduler scheduler;
    private final SerializationService serializationService;
    private final MinimalPartitionService partitionService;
    private final int partitionCount;
    private final AtomicReferenceArray<UUID> partitionUuids;
    private final String localUuid;
    private final ILogger logger;
    private volatile long lastAntiEntropyRunNanos;

    public RepairingTask(HazelcastProperties properties, MetaDataFetcher metaDataFetcher, TaskScheduler scheduler, SerializationService serializationService, MinimalPartitionService partitionService, String localUuid, ILogger logger) {
        this.reconciliationIntervalNanos = TimeUnit.SECONDS.toNanos(this.checkAndGetReconciliationIntervalSeconds(properties));
        this.maxToleratedMissCount = this.checkMaxToleratedMissCount(properties);
        this.metaDataFetcher = metaDataFetcher;
        this.scheduler = scheduler;
        this.serializationService = serializationService;
        this.partitionService = partitionService;
        this.partitionCount = partitionService.getPartitionCount();
        this.partitionUuids = new AtomicReferenceArray(this.partitionCount);
        this.localUuid = localUuid;
        this.logger = logger;
    }

    private int checkMaxToleratedMissCount(HazelcastProperties properties) {
        int maxToleratedMissCount = properties.getInteger(MAX_TOLERATED_MISS_COUNT);
        return Preconditions.checkNotNegative(maxToleratedMissCount, String.format("max-tolerated-miss-count cannot be < 0 but found %d", maxToleratedMissCount));
    }

    private int checkAndGetReconciliationIntervalSeconds(HazelcastProperties properties) {
        int reconciliationIntervalSeconds = properties.getInteger(RECONCILIATION_INTERVAL_SECONDS);
        if (reconciliationIntervalSeconds < 0 || (long)reconciliationIntervalSeconds > 0L && (long)reconciliationIntervalSeconds < 30L) {
            String msg = String.format("Reconciliation interval can be at least %d seconds if it is not zero but found %d. Note that giving zero disables reconciliation task.", 30L, reconciliationIntervalSeconds);
            throw new IllegalArgumentException(msg);
        }
        return reconciliationIntervalSeconds;
    }

    @Override
    public void run() {
        try {
            this.fixSequenceGaps();
            this.runAntiEntropyIfNeeded();
        }
        finally {
            if (this.running.get()) {
                this.scheduleNextRun();
            }
        }
    }

    private void fixSequenceGaps() {
        for (RepairingHandler handler : this.handlers.values()) {
            if (!this.isAboveMaxToleratedMissCount(handler)) continue;
            this.updateLastKnownStaleSequences(handler);
        }
    }

    private void runAntiEntropyIfNeeded() {
        if (this.reconciliationIntervalNanos == 0L) {
            return;
        }
        long sinceLastRun = System.nanoTime() - this.lastAntiEntropyRunNanos;
        if (sinceLastRun >= this.reconciliationIntervalNanos) {
            this.metaDataFetcher.fetchMetadata(this.handlers);
            this.lastAntiEntropyRunNanos = System.nanoTime();
        }
    }

    private void scheduleNextRun() {
        block2: {
            try {
                this.scheduler.schedule(this, 1L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!this.logger.isFinestEnabled()) break block2;
                this.logger.finest(e.getMessage());
            }
        }
    }

    public <K, V> RepairingHandler registerAndGetHandler(String name, NearCache<K, V> nearCache) {
        RepairingHandler repairingHandler;
        boolean started = this.running.compareAndSet(false, true);
        if (started) {
            this.assignAndGetUuids();
        }
        if ((repairingHandler = (RepairingHandler)this.handlers.get(name)) == null) {
            repairingHandler = new RepairingHandler(this.logger, this.localUuid, name, nearCache, this.serializationService, this.partitionService);
            repairingHandler.initUnknownUuids(this.partitionUuids);
            StaleReadDetectorImpl staleReadDetector = new StaleReadDetectorImpl(repairingHandler, this.partitionService);
            nearCache.unwrap(DefaultNearCache.class).getNearCacheRecordStore().setStaleReadDetector(staleReadDetector);
            this.handlers.put(name, repairingHandler);
        }
        if (started) {
            this.scheduleNextRun();
            this.lastAntiEntropyRunNanos = System.nanoTime();
        }
        return repairingHandler;
    }

    public void deregisterHandler(String mapName) {
        this.handlers.remove(mapName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignAndGetUuids() {
        this.logger.finest("Making initial population of partition uuids");
        boolean initialized = false;
        try {
            for (Map.Entry<Integer, UUID> entry : this.metaDataFetcher.assignAndGetUuids()) {
                Integer partition = entry.getKey();
                UUID uuid = entry.getValue();
                this.partitionUuids.set(partition, uuid);
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest(partition + "-" + uuid);
            }
            initialized = true;
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        finally {
            if (!initialized) {
                this.assignAndGetUuidsAsync();
            }
        }
    }

    private void assignAndGetUuidsAsync() {
        this.scheduler.schedule(new Runnable(){
            private final AtomicInteger round = new AtomicInteger();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int roundNumber = this.round.incrementAndGet();
                boolean initialized = false;
                try {
                    RepairingTask.this.assignAndGetUuids();
                    for (RepairingHandler repairingHandler : RepairingTask.this.handlers.values()) {
                        repairingHandler.initUnknownUuids(RepairingTask.this.partitionUuids);
                    }
                    initialized = true;
                }
                catch (Exception e) {
                    if (RepairingTask.this.logger.isFinestEnabled()) {
                        RepairingTask.this.logger.finest(e);
                    }
                }
                finally {
                    if (!initialized) {
                        long delay = (long)roundNumber * 500L;
                        if (delay > HALF_MINUTE_MILLIS) {
                            this.round.set(0);
                        }
                        RepairingTask.this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    private boolean isAboveMaxToleratedMissCount(RepairingHandler handler) {
        int partition = 0;
        long missCount = 0L;
        do {
            MetaDataContainer metaData;
            if ((missCount += (metaData = handler.getMetaDataContainer(partition)).getMissedSequenceCount()) <= (long)this.maxToleratedMissCount) continue;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("%s:[map=%s,missCount=%d,maxToleratedMissCount=%d]", "Above tolerated miss count", handler.getName(), missCount, this.maxToleratedMissCount));
            }
            return true;
        } while (++partition < this.partitionCount);
        return false;
    }

    private void updateLastKnownStaleSequences(RepairingHandler handler) {
        for (int partition = 0; partition < this.partitionCount; ++partition) {
            MetaDataContainer metaData = handler.getMetaDataContainer(partition);
            long missCount = metaData.getMissedSequenceCount();
            if (missCount == 0L) continue;
            metaData.addAndGetMissedSequenceCount(-missCount);
            handler.updateLastKnownStaleSequence(metaData, partition);
        }
    }

    public MetaDataFetcher getMetaDataFetcher() {
        return this.metaDataFetcher;
    }

    public ConcurrentMap<String, RepairingHandler> getHandlers() {
        return this.handlers;
    }

    public AtomicReferenceArray<UUID> getPartitionUuids() {
        return this.partitionUuids;
    }

    public String toString() {
        return "RepairingTask{}";
    }
}

