/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking;

import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelCloseListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractChannel
implements Channel {
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<AbstractChannel> CLOSED = AtomicIntegerFieldUpdater.newUpdater(AbstractChannel.class, "closed");
    protected final SocketChannel socketChannel;
    private final ConcurrentMap<?, ?> attributeMap = new ConcurrentHashMap();
    private final Set<ChannelCloseListener> closeListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final boolean clientMode;
    private volatile int closed = 0;

    public AbstractChannel(SocketChannel socketChannel, boolean clientMode) {
        this.socketChannel = socketChannel;
        this.clientMode = clientMode;
    }

    @Override
    public boolean isClientMode() {
        return this.clientMode;
    }

    @Override
    public ConcurrentMap attributeMap() {
        return this.attributeMap;
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        Socket socket = this.socket();
        return socket == null ? null : socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        Socket socket = this.socket();
        return socket == null ? null : socket.getLocalSocketAddress();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socketChannel.write(src);
    }

    @Override
    public void closeInbound() throws IOException {
    }

    @Override
    public void closeOutbound() throws IOException {
    }

    @Override
    public boolean isClosed() {
        return this.closed == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!CLOSED.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (Throwable throwable) {
            for (ChannelCloseListener closeListener : this.closeListeners) {
                try {
                    closeListener.onClose(this);
                }
                catch (Exception e) {
                    ILogger logger = Logger.getLogger(this.getClass());
                    logger.severe(String.format("Failed to process closeListener [%s] on channel [%s]", closeListener, this), e);
                }
            }
            throw throwable;
        }
        for (ChannelCloseListener closeListener : this.closeListeners) {
            try {
                closeListener.onClose(this);
            }
            catch (Exception e) {
                ILogger logger = Logger.getLogger(this.getClass());
                logger.severe(String.format("Failed to process closeListener [%s] on channel [%s]", closeListener, this), e);
            }
        }
    }

    @Override
    public void addCloseListener(ChannelCloseListener listener) {
        this.closeListeners.add(Preconditions.checkNotNull(listener, "listener"));
    }
}

