/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.nio.MigratableHandler;
import com.hazelcast.internal.networking.nio.NioChannel;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.internal.networking.nio.SelectionHandler;
import com.hazelcast.internal.networking.nio.iobalancer.IOBalancer;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public abstract class AbstractHandler
implements SelectionHandler,
MigratableHandler {
    protected static final int LOAD_BALANCING_HANDLE = 0;
    protected static final int LOAD_BALANCING_BYTE = 1;
    protected static final int LOAD_BALANCING_FRAME = 2;
    protected static final int LOAD_TYPE = Integer.getInteger("hazelcast.io.load", 1);
    @Probe
    protected final SwCounter handleCount = SwCounter.newSwCounter();
    @Probe
    protected final SwCounter completedMigrations = SwCounter.newSwCounter();
    protected final ILogger logger;
    protected final Channel channel;
    protected NioThread ioThread;
    protected SelectionKey selectionKey;
    private final SocketChannel socketChannel;
    private final int initialOps;
    private final IOBalancer ioBalancer;
    @Probe
    private volatile int ioThreadId;
    @Probe
    private final SwCounter migrationCount = SwCounter.newSwCounter();

    AbstractHandler(NioChannel channel, NioThread ioThread, int initialOps, ILogger logger, IOBalancer ioBalancer) {
        this.channel = channel;
        this.socketChannel = channel.socketChannel();
        this.ioThread = ioThread;
        this.ioThreadId = ioThread.id;
        this.logger = logger;
        this.initialOps = initialOps;
        this.ioBalancer = ioBalancer;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsInterested() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.interestOps();
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsReady() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.readyOps();
    }

    @Override
    public NioThread getOwner() {
        return this.ioThread;
    }

    public void start() {
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractHandler.this.getSelectionKey();
                }
                catch (Throwable t) {
                    AbstractHandler.this.onFailure(t);
                }
            }
        });
    }

    SelectionKey getSelectionKey() throws IOException {
        if (this.selectionKey == null) {
            this.selectionKey = this.socketChannel.register(this.ioThread.getSelector(), this.initialOps, this);
        }
        return this.selectionKey;
    }

    final void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    final void registerOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() | operation);
    }

    final void unregisterOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        int interestOps = selectionKey.interestOps();
        if ((interestOps & operation) != 0) {
            selectionKey.interestOps(interestOps & ~operation);
        }
    }

    protected abstract void publish();

    @Override
    public void onFailure(Throwable e) {
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.ioThread.getErrorHandler().onError(this.channel, e);
    }

    void startMigration(final NioThread newOwner) throws IOException {
        assert (this.ioThread == Thread.currentThread()) : "startMigration can only run on the owning NioThread";
        assert (this.ioThread != newOwner) : "newOwner can't be the same as the existing owner";
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.migrationCount.inc();
        this.unregisterOp(this.initialOps);
        this.ioThread = newOwner;
        this.ioThreadId = this.ioThread.id;
        this.selectionKey.cancel();
        this.selectionKey = null;
        newOwner.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractHandler.this.completeMigration(newOwner);
                }
                catch (Throwable t) {
                    AbstractHandler.this.onFailure(t);
                }
            }
        });
    }

    private void completeMigration(NioThread newOwner) throws IOException {
        assert (this.ioThread == newOwner);
        this.completedMigrations.inc();
        this.ioBalancer.signalMigrationComplete();
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.selectionKey = this.getSelectionKey();
        this.registerOp(this.initialOps);
    }
}

