/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.OperationService;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class InvocationUtil {
    private static final int WARMUP_SLEEPING_TIME_MILLIS = 10;
    private static final int INVOCATION_TIMEOUT_SECONDS = 60;

    private InvocationUtil() {
    }

    public static void invokeOnStableClusterSerial(NodeEngine nodeEngine, OperationFactory operationFactory, int retriesCount) {
        Set<Member> originalMembers;
        boolean success;
        OperationService operationService = nodeEngine.getOperationService();
        ClusterService cluster = nodeEngine.getClusterService();
        InvocationUtil.warmUpPartitions(nodeEngine);
        int iterationCounter = 0;
        while (!(success = InvocationUtil.invokeOnMembers(operationService, operationFactory, originalMembers = cluster.getMembers())) || !cluster.getMembers().equals(originalMembers)) {
            if (iterationCounter++ != retriesCount) continue;
            throw new HazelcastException(String.format("Cluster topology was not stable for %d retries, invoke on stable cluster failed", retriesCount));
        }
    }

    private static boolean invokeOnMembers(OperationService operationService, OperationFactory operationFactory, Collection<Member> members) {
        for (Member member : members) {
            Address target = member.getAddress();
            Operation operation = operationFactory.createOperation();
            String serviceName = operation.getServiceName();
            InternalCompletableFuture future = operationService.invokeOnTarget(serviceName, operation, target);
            try {
                future.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new HazelcastException("Interrupted while invoking " + operation + " on " + member, e);
            }
            catch (MemberLeftException e) {
                return false;
            }
            catch (ExecutionException e) {
                throw new HazelcastException("Error while invoking " + operation + " on " + member, e);
            }
            catch (TimeoutException e) {
                throw new HazelcastException("Timeout while invoking " + operation + " on " + member, e);
            }
        }
        return true;
    }

    private static void warmUpPartitions(NodeEngine nodeEngine) {
        PartitionService ps = nodeEngine.getHazelcastInstance().getPartitionService();
        for (Partition partition : ps.getPartitions()) {
            while (partition.getOwner() == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new HazelcastException("Thread interrupted while initializing a partition table", e);
                }
            }
        }
    }
}

