/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryDispatcher;
import com.hazelcast.map.impl.query.QueryResultSizeLimiter;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.map.impl.query.Target;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MapQueryEngineImpl
implements MapQueryEngine {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final QueryResultSizeLimiter queryResultSizeLimiter;
    protected final InternalSerializationService serializationService;
    protected final IPartitionService partitionService;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final QueryDispatcher queryDispatcher;
    protected final ResultProcessorRegistry resultProcessorRegistry;

    public MapQueryEngineImpl(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.queryDispatcher = new QueryDispatcher(mapServiceContext);
        this.resultProcessorRegistry = mapServiceContext.getResultProcessorRegistry();
    }

    public Result execute(Query query, Target target) {
        Query adjustedQuery = this.adjustQuery(query);
        if (target.isTargetAllNodes()) {
            return this.runQueryOnAllPartitions(adjustedQuery);
        }
        if (target.isTargetLocalNode()) {
            return this.runQueryOnLocalPartitions(adjustedQuery);
        }
        if (target.isTargetPartitionOwner()) {
            return this.runQueryOnGivenPartition(query, target);
        }
        throw new IllegalArgumentException("Illegal target " + query);
    }

    private Query adjustQuery(Query query) {
        IterationType retrievalIterationType = this.getRetrievalIterationType(query.getPredicate(), query.getIterationType());
        Query adjustedQuery = Query.of(query).iterationType(retrievalIterationType).build();
        if (adjustedQuery.getPredicate() instanceof PagingPredicate) {
            ((PagingPredicate)adjustedQuery.getPredicate()).setIterationType(query.getIterationType());
        } else if (adjustedQuery.getPredicate() == TruePredicate.INSTANCE) {
            this.queryResultSizeLimiter.precheckMaxResultLimitOnLocalPartitions(adjustedQuery.getMapName());
        }
        return adjustedQuery;
    }

    private Result runQueryOnLocalPartitions(Query query) {
        List<Integer> mutablePartitionIds = this.getLocalPartitionIds();
        Result result = this.doRunQueryOnQueryThreads(query, mutablePartitionIds, Target.LOCAL_NODE);
        if (this.isResultFromAnyPartitionMissing(mutablePartitionIds)) {
            this.doRunQueryOnPartitionThreads(query, mutablePartitionIds, result);
        }
        return result;
    }

    private Result runQueryOnAllPartitions(Query query) {
        Set<Integer> mutablePartitionIds = this.getAllPartitionIds();
        Result result = this.doRunQueryOnQueryThreads(query, mutablePartitionIds, Target.ALL_NODES);
        if (this.isResultFromAnyPartitionMissing(mutablePartitionIds)) {
            this.doRunQueryOnPartitionThreads(query, mutablePartitionIds, result);
        }
        return result;
    }

    private Result runQueryOnGivenPartition(Query query, Target target) {
        try {
            return this.queryDispatcher.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, target.getPartitionId()).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private Result doRunQueryOnQueryThreads(Query query, Collection<Integer> partitionIds, Target target) {
        Object result = this.resultProcessorRegistry.get(query.getResultType()).populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(partitionIds.size()));
        this.dispatchQueryOnQueryThreads(query, target, partitionIds, (Result)result);
        return result;
    }

    private void dispatchQueryOnQueryThreads(Query query, Target target, Collection<Integer> partitionIds, Result result) {
        try {
            List<Future<Result>> futures = this.queryDispatcher.dispatchFullQueryOnQueryThread(query, target);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.fine("Could not get results", t);
        }
    }

    private void doRunQueryOnPartitionThreads(Query query, Collection<Integer> partitionIds, Result result) {
        try {
            List<Future<Result>> futures = this.queryDispatcher.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, partitionIds);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void addResultsOfPredicate(List<Future<Result>> futures, Result result, Collection<Integer> partitionIds) throws ExecutionException, InterruptedException {
        for (Future<Result> future : futures) {
            Collection<Integer> queriedPartitionIds;
            Result queryResult = future.get();
            if (queryResult == null || (queriedPartitionIds = queryResult.getPartitionIds()) == null || !partitionIds.containsAll(queriedPartitionIds)) continue;
            partitionIds.removeAll(queriedPartitionIds);
            result.combine(queryResult);
        }
    }

    private IterationType getRetrievalIterationType(Predicate predicate, IterationType iterationType) {
        IterationType retrievalIterationType = iterationType;
        if (predicate instanceof PagingPredicate) {
            retrievalIterationType = iterationType == IterationType.VALUE ? IterationType.ENTRY : iterationType;
        }
        return retrievalIterationType;
    }

    private List<Integer> getLocalPartitionIds() {
        return this.partitionService.getMemberPartitions(this.nodeEngine.getThisAddress());
    }

    private Set<Integer> getAllPartitionIds() {
        int partitionCount = this.partitionService.getPartitionCount();
        return MapQueryEngineImpl.createSetWithPopulatedPartitionIds(partitionCount);
    }

    private boolean isResultFromAnyPartitionMissing(Collection<Integer> partitionIds) {
        return !partitionIds.isEmpty();
    }

    private static Set<Integer> createSetWithPopulatedPartitionIds(int partitionCount) {
        HashSet<Integer> partitionIds = new HashSet<Integer>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            partitionIds.add(i);
        }
        return partitionIds;
    }

    protected QueryResultSizeLimiter getQueryResultSizeLimiter() {
        return this.queryResultSizeLimiter;
    }
}

