/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionCandidate;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.eviction.impl.strategy.sampling.SampleableEvictableStore;
import com.hazelcast.map.impl.querycache.subscriber.record.QueryCacheRecord;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializableByConvention;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import com.hazelcast.util.SampleableConcurrentHashMap;
import java.util.EnumSet;

@SerializableByConvention
public class QueryCacheRecordHashMap
extends SampleableConcurrentHashMap<Data, QueryCacheRecord>
implements SampleableEvictableStore<Data, QueryCacheRecord> {
    private final SerializationService serializationService;

    public QueryCacheRecordHashMap(SerializationService serializationService, int initialCapacity) {
        super(initialCapacity);
        this.serializationService = serializationService;
    }

    public QueryCacheRecordHashMap(SerializationService serializationService, int initialCapacity, float loadFactor, int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType, EnumSet<ConcurrentReferenceHashMap.Option> options) {
        super(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options);
        this.serializationService = serializationService;
    }

    @Override
    protected QueryCacheEvictableSamplingEntry createSamplingEntry(Data key, QueryCacheRecord value) {
        return new QueryCacheEvictableSamplingEntry(key, value);
    }

    @Override
    public <C extends EvictionCandidate<Data, QueryCacheRecord>> int evict(Iterable<C> evictionCandidates, EvictionListener<Data, QueryCacheRecord> evictionListener) {
        if (evictionCandidates == null) {
            return 0;
        }
        int actualEvictedCount = 0;
        for (EvictionCandidate evictionCandidate : evictionCandidates) {
            if (this.remove(evictionCandidate.getAccessor()) == null) continue;
            ++actualEvictedCount;
            if (evictionListener == null) continue;
            evictionListener.onEvict((Data)evictionCandidate.getAccessor(), (QueryCacheRecord)evictionCandidate.getEvictable(), false);
        }
        return actualEvictedCount;
    }

    @Override
    public Iterable<QueryCacheEvictableSamplingEntry> sample(int sampleCount) {
        return super.getRandomSamples(sampleCount);
    }

    public class QueryCacheEvictableSamplingEntry
    extends SampleableConcurrentHashMap.SamplingEntry<Data, QueryCacheRecord>
    implements EvictionCandidate {
        public QueryCacheEvictableSamplingEntry(Data key, QueryCacheRecord value) {
            super(key, value);
        }

        public Object getAccessor() {
            return this.key;
        }

        public Evictable getEvictable() {
            return (Evictable)this.value;
        }

        public Object getKey() {
            return QueryCacheRecordHashMap.this.serializationService.toObject(this.key);
        }

        public Object getValue() {
            return QueryCacheRecordHashMap.this.serializationService.toObject(((QueryCacheRecord)this.value).getValue());
        }

        @Override
        public long getCreationTime() {
            return ((QueryCacheRecord)this.value).getCreationTime();
        }

        @Override
        public long getLastAccessTime() {
            return ((QueryCacheRecord)this.value).getLastAccessTime();
        }

        @Override
        public long getAccessHit() {
            return ((QueryCacheRecord)this.value).getAccessHit();
        }
    }
}

