/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorHandler;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.accumulator.BasicAccumulator;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventData;
import com.hazelcast.map.impl.querycache.event.sequence.DefaultSubscriberSequencerProvider;
import com.hazelcast.map.impl.querycache.event.sequence.Sequenced;
import com.hazelcast.map.impl.querycache.event.sequence.SubscriberSequencerProvider;
import com.hazelcast.map.impl.querycache.subscriber.EventPublisherHelper;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheFactory;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberAccumulatorHandler;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SubscriberAccumulator
extends BasicAccumulator<QueryCacheEventData> {
    private final ConcurrentMap<Integer, Long> brokenSequences = new ConcurrentHashMap<Integer, Long>();
    private final AccumulatorHandler handler = this.createAccumulatorHandler();
    private final SubscriberSequencerProvider sequenceProvider = this.createSequencerProvider();

    protected SubscriberAccumulator(QueryCacheContext context, AccumulatorInfo info) {
        super(context, info);
    }

    @Override
    public void accumulate(QueryCacheEventData event) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Received event=" + event);
        }
        if (!this.isApplicable(event)) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Event was not inserted to queryCache=" + event);
            }
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Event was added to queryCache=" + event);
        }
        this.addQueryCache(event);
    }

    private boolean isApplicable(QueryCacheEventData event) {
        if (!this.getInfo().isPublishable()) {
            return false;
        }
        int partitionId = event.getPartitionId();
        if (this.isEndEvent(event)) {
            this.sequenceProvider.reset(partitionId);
            this.removeFromBrokenSequences(event);
            return false;
        }
        if (this.isNextEvent(event)) {
            long currentSequence = this.sequenceProvider.getSequence(partitionId);
            this.sequenceProvider.compareAndSetSequence(currentSequence, event.getSequence(), partitionId);
            this.removeFromBrokenSequences(event);
            return true;
        }
        this.handleUnexpectedEvent(event);
        return false;
    }

    private void removeFromBrokenSequences(QueryCacheEventData event) {
        if (this.brokenSequences.isEmpty()) {
            return;
        }
        int partitionId = event.getPartitionId();
        long sequence = event.getSequence();
        if (sequence == -1L) {
            this.brokenSequences.remove(partitionId);
        } else {
            Long expected = (Long)this.brokenSequences.get(partitionId);
            if (expected != null && expected.longValue() == event.getSequence()) {
                this.brokenSequences.remove(partitionId);
            }
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Size of broken sequences=%d", this.brokenSequences.size()));
        }
    }

    private void handleUnexpectedEvent(QueryCacheEventData event) {
        this.addEventSequenceToBrokenSequences(event);
        EventPublisherHelper.publishEventLost(this.context, this.info.getMapName(), this.info.getCacheName(), event.getPartitionId());
    }

    private void addEventSequenceToBrokenSequences(QueryCacheEventData event) {
        Long prev = this.brokenSequences.putIfAbsent(event.getPartitionId(), event.getSequence());
        if (prev == null && this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Added unexpected event sequence to broken sequences [partitionId=%d, expected-sequence=%d, broken-sequences-size=%d]", event.getPartitionId(), event.getSequence(), this.brokenSequences.size()));
        }
    }

    protected boolean isNextEvent(Sequenced event) {
        long expectedSequence;
        boolean isNextSequence;
        int partitionId = event.getPartitionId();
        long currentSequence = this.sequenceProvider.getSequence(partitionId);
        long foundSequence = event.getSequence();
        boolean bl = isNextSequence = foundSequence == (expectedSequence = currentSequence + 1L);
        if (!isNextSequence && this.logger.isWarningEnabled()) {
            this.logger.warning(String.format("Event lost detected for partitionId=%d, expectedSequence=%d but foundSequence=%d, cacheSize=%d", partitionId, expectedSequence, foundSequence, this.getQueryCache().size()));
        }
        return isNextSequence;
    }

    private InternalQueryCache getQueryCache() {
        AccumulatorInfo info = this.getInfo();
        String cacheName = info.getCacheName();
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        QueryCacheFactory queryCacheFactory = subscriberContext.getQueryCacheFactory();
        return queryCacheFactory.getOrNull(cacheName);
    }

    private SubscriberAccumulatorHandler createAccumulatorHandler() {
        AccumulatorInfo info = this.getInfo();
        boolean includeValue = info.isIncludeValue();
        InternalQueryCache queryCache = this.getQueryCache();
        InternalSerializationService serializationService = this.context.getSerializationService();
        return new SubscriberAccumulatorHandler(includeValue, queryCache, serializationService);
    }

    private void addQueryCache(QueryCacheEventData eventData) {
        this.handler.handle(eventData, false);
    }

    protected SubscriberSequencerProvider createSequencerProvider() {
        return new DefaultSubscriberSequencerProvider();
    }

    public ConcurrentMap<Integer, Long> getBrokenSequences() {
        return this.brokenSequences;
    }

    public boolean isEndEvent(QueryCacheEventData event) {
        return event.getSequence() == -1L;
    }
}

