/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.internal.nearcache.impl.invalidation.ToHeapDataConverter;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.ExpirationManager;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.AbstractRecordStore;
import com.hazelcast.map.impl.recordstore.ExpiredKey;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class AbstractEvictableRecordStore
extends AbstractRecordStore {
    protected final long expiryDelayMillis;
    protected final EventService eventService;
    protected final MapEventPublisher mapEventPublisher;
    protected final Address thisAddress;
    protected final ExpirationManager expirationManager;
    protected final InvalidationQueue<ExpiredKey> expiredKeys = new InvalidationQueue();
    protected Iterator<Record> expirationIterator;
    protected volatile boolean hasEntryWithCustomTTL;

    protected AbstractEvictableRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        HazelcastProperties hazelcastProperties = nodeEngine.getProperties();
        this.expiryDelayMillis = hazelcastProperties.getMillis(GroupProperty.MAP_EXPIRY_DELAY_SECONDS);
        this.eventService = nodeEngine.getEventService();
        this.mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        this.thisAddress = nodeEngine.getThisAddress();
        this.expirationManager = this.mapServiceContext.getExpirationManager();
    }

    private boolean isRecordStoreExpirable() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        return this.hasEntryWithCustomTTL || mapConfig.getMaxIdleSeconds() > 0 || mapConfig.getTimeToLiveSeconds() > 0;
    }

    @Override
    public void evictExpiredEntries(int percentage, boolean backup) {
        long now = this.getNow();
        int size = this.size();
        int maxIterationCount = this.getMaxIterationCount(size, percentage);
        int maxRetry = 3;
        int loop = 0;
        int evictedEntryCount = 0;
        while ((evictedEntryCount += this.evictExpiredEntriesInternal(maxIterationCount, now, backup)) < maxIterationCount && ++loop <= 3) {
        }
        this.accumulateOrSendExpiredKey(null);
    }

    @Override
    public boolean isExpirable() {
        return this.isRecordStoreExpirable();
    }

    private int getMaxIterationCount(int size, int percentage) {
        int defaultMaxIterationCount = 100;
        float oneHundred = 100.0f;
        float maxIterationCount = (float)size * ((float)percentage / 100.0f);
        if (maxIterationCount <= 100.0f) {
            return 100;
        }
        return Math.round(maxIterationCount);
    }

    private int evictExpiredEntriesInternal(int maxIterationCount, long now, boolean backup) {
        int evictedCount = 0;
        int checkedEntryCount = 0;
        this.initExpirationIterator();
        while (this.expirationIterator.hasNext() && checkedEntryCount < maxIterationCount) {
            ++checkedEntryCount;
            Record record = this.expirationIterator.next();
            if ((record = this.getOrNullIfExpired(record, now, backup)) != null) continue;
            ++evictedCount;
        }
        return evictedCount;
    }

    private void initExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = this.storage.values().iterator();
        }
    }

    @Override
    public void evictEntries(Data excludedKey) {
        if (this.shouldEvict()) {
            this.mapContainer.getEvictor().evict(this, excludedKey);
        }
    }

    @Override
    public boolean shouldEvict() {
        Evictor evictor = this.mapContainer.getEvictor();
        return evictor != Evictor.NULL_EVICTOR && evictor.checkEvictable(this);
    }

    protected void markRecordStoreExpirable(long ttl) {
        if (ttl > 0L && ttl < Long.MAX_VALUE) {
            this.hasEntryWithCustomTTL = true;
        }
    }

    protected Record getOrNullIfExpired(Record record, long now, boolean backup) {
        if (!this.isRecordStoreExpirable()) {
            return record;
        }
        if (record == null) {
            return null;
        }
        Data key = record.getKey();
        if (this.isLocked(key)) {
            return record;
        }
        if (!this.isExpired(record, now, backup)) {
            return record;
        }
        this.evict(key, backup);
        if (!backup) {
            this.doPostEvictionOperations(record, backup);
        }
        return null;
    }

    @Override
    public boolean isExpired(Record record, long now, boolean backup) {
        return record == null || this.isIdleExpired(record, now, backup) || this.isTTLExpired(record, now, backup);
    }

    private boolean isIdleExpired(Record record, long now, boolean backup) {
        long idleMillis;
        if (backup && this.expirationManager.canPrimaryDriveExpiration()) {
            return false;
        }
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(this.mapContainer.getMapConfig());
        if (maxIdleMillis == Long.MAX_VALUE) {
            return false;
        }
        long idlenessStartTime = ExpirationTimeSetter.getIdlenessStartTime(record);
        long elapsedMillis = now - idlenessStartTime;
        return elapsedMillis >= (idleMillis = ExpirationTimeSetter.calculateExpirationWithDelay(maxIdleMillis, this.expiryDelayMillis, backup));
    }

    private boolean isTTLExpired(Record record, long now, boolean backup) {
        long ttlMillis;
        if (record == null) {
            return false;
        }
        long ttl = record.getTtl();
        if (ttl < 1L || ttl == Long.MAX_VALUE) {
            return false;
        }
        long ttlStartTime = ExpirationTimeSetter.getLifeStartTime(record);
        long elapsedMillis = now - ttlStartTime;
        return elapsedMillis >= (ttlMillis = ExpirationTimeSetter.calculateExpirationWithDelay(ttl, this.expiryDelayMillis, backup));
    }

    @Override
    public void doPostEvictionOperations(Record record, boolean backup) {
        boolean expired;
        Data key = record.getKey();
        Object value = record.getValue();
        boolean hasEventRegistration = this.eventService.hasEventRegistration("hz:impl:mapService", this.name);
        if (hasEventRegistration) {
            this.mapEventPublisher.publishEvent(this.thisAddress, this.name, EntryEventType.EVICTED, key, value, null);
        }
        long now = this.getNow();
        boolean idleExpired = this.isIdleExpired(record, now, backup);
        boolean ttlExpired = this.isTTLExpired(record, now, backup);
        boolean bl = expired = idleExpired || ttlExpired;
        if (expired && hasEventRegistration) {
            this.mapEventPublisher.publishEvent(this.thisAddress, this.name, EntryEventType.EXPIRED, key, value, null);
        }
        if (!ttlExpired && idleExpired) {
            this.accumulateOrSendExpiredKey(record);
        }
    }

    @Override
    public InvalidationQueue<ExpiredKey> getExpiredKeys() {
        return this.expiredKeys;
    }

    private void accumulateOrSendExpiredKey(Record record) {
        if (this.mapContainer.getMapConfig().getMaxIdleSeconds() <= 0 || this.mapContainer.getTotalBackupCount() == 0) {
            return;
        }
        if (record != null) {
            this.expiredKeys.offer(new ExpiredKey(ToHeapDataConverter.toHeapData(record.getKey()), record.getCreationTime()));
        }
        this.expirationManager.sendExpiredKeysToBackups(this, true);
    }

    protected void accessRecord(Record record, long now) {
        record.onAccess(now);
        this.updateStatsOnGet(now);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(this.mapContainer.getMapConfig());
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
    }

    protected void mergeRecordExpiration(Record record, EntryView mergingEntry) {
        long ttlMillis = mergingEntry.getTtl();
        record.setTtl(ttlMillis);
        long creationTime = mergingEntry.getCreationTime();
        record.setCreationTime(creationTime);
        long lastAccessTime = mergingEntry.getLastAccessTime();
        record.setLastAccessTime(lastAccessTime);
        long lastUpdateTime = mergingEntry.getLastUpdateTime();
        record.setLastUpdateTime(lastUpdateTime);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(this.mapContainer.getMapConfig());
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
        this.markRecordStoreExpirable(record.getTtl());
    }

    protected final class ReadOnlyRecordIterator
    implements Iterator<Record> {
        private final long now;
        private final boolean checkExpiration;
        private final boolean backup;
        private final Iterator<Record> iterator;
        private Record nextRecord;
        private Record lastReturned;

        protected ReadOnlyRecordIterator(Collection<Record> values, long now, boolean backup) {
            this(values, now, true, backup);
        }

        protected ReadOnlyRecordIterator(Collection<Record> values) {
            this(values, -1L, false, false);
        }

        private ReadOnlyRecordIterator(Collection<Record> values, long now, boolean checkExpiration, boolean backup) {
            this.iterator = values.iterator();
            this.now = now;
            this.checkExpiration = checkExpiration;
            this.backup = backup;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Record next() {
            if (this.nextRecord == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextRecord;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported by this iterator");
        }

        private void advance() {
            long now = this.now;
            boolean checkExpiration = this.checkExpiration;
            Iterator<Record> iterator = this.iterator;
            while (iterator.hasNext()) {
                this.nextRecord = iterator.next();
                if (this.nextRecord == null) continue;
                if (!checkExpiration) {
                    return;
                }
                if (AbstractEvictableRecordStore.this.isExpired(this.nextRecord, now, this.backup)) continue;
                return;
            }
            this.nextRecord = null;
        }
    }
}

