/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.VersionAware;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.ringbuffer.impl.ArrayRingbuffer;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.ringbuffer.impl.Ringbuffer;
import com.hazelcast.ringbuffer.impl.RingbufferDataSerializerHook;
import com.hazelcast.ringbuffer.impl.RingbufferExpirationPolicy;
import com.hazelcast.ringbuffer.impl.RingbufferStoreWrapper;
import com.hazelcast.ringbuffer.impl.RingbufferWaitNotifyKey;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.serialization.SerializationService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RingbufferContainer<T>
implements IdentifiedDataSerializable,
Notifier,
Versioned {
    private static final long TTL_DISABLED = 0L;
    private ObjectNamespace namespace;
    private RingbufferWaitNotifyKey emptyRingWaitNotifyKey;
    private RingbufferExpirationPolicy expirationPolicy;
    private InMemoryFormat inMemoryFormat;
    private RingbufferConfig config;
    private RingbufferStoreWrapper store;
    private SerializationService serializationService;
    private Ringbuffer ringbuffer;

    public RingbufferContainer() {
    }

    public RingbufferContainer(ObjectNamespace namespace) {
        this.namespace = namespace;
        this.emptyRingWaitNotifyKey = new RingbufferWaitNotifyKey(namespace);
    }

    public RingbufferContainer(ObjectNamespace namespace, RingbufferConfig config, SerializationService serializationService, ClassLoader configClassLoader) {
        this(namespace);
        this.inMemoryFormat = config.getInMemoryFormat();
        this.ringbuffer = new ArrayRingbuffer(config.getCapacity());
        long ttlMs = TimeUnit.SECONDS.toMillis(config.getTimeToLiveSeconds());
        if (ttlMs != 0L) {
            this.expirationPolicy = new RingbufferExpirationPolicy(this.ringbuffer.getCapacity(), ttlMs);
        }
        this.init(config, serializationService, configClassLoader);
    }

    public void init(RingbufferConfig config, SerializationService serializationService, ClassLoader configClassLoader) {
        this.config = config;
        this.serializationService = serializationService;
        this.initRingbufferStore(config, serializationService, configClassLoader);
    }

    private void initRingbufferStore(RingbufferConfig config, SerializationService serializationService, ClassLoader configClassLoader) {
        this.store = RingbufferStoreWrapper.create(this.namespace, config.getRingbufferStoreConfig(), config.getInMemoryFormat(), serializationService, configClassLoader);
        if (this.store.isEnabled()) {
            try {
                long storeSequence = this.store.getLargestSequence();
                this.ringbuffer.setTailSequence(storeSequence);
                this.ringbuffer.setHeadSequence(storeSequence + 1L);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
    }

    public RingbufferStoreWrapper getStore() {
        return this.store;
    }

    public RingbufferWaitNotifyKey getRingEmptyWaitNotifyKey() {
        return this.emptyRingWaitNotifyKey;
    }

    public RingbufferConfig getConfig() {
        return this.config;
    }

    public long tailSequence() {
        return this.ringbuffer.tailSequence();
    }

    public long headSequence() {
        return this.ringbuffer.headSequence();
    }

    public void setHeadSequence(long sequence) {
        this.ringbuffer.setHeadSequence(sequence);
    }

    public long getCapacity() {
        return this.ringbuffer.getCapacity();
    }

    public long size() {
        return this.ringbuffer.size();
    }

    public boolean isEmpty() {
        return this.ringbuffer.isEmpty();
    }

    public boolean shouldWait(long sequence) {
        this.checkBlockableReadSequence(sequence);
        return sequence == this.ringbuffer.tailSequence() + 1L;
    }

    public long remainingCapacity() {
        if (this.expirationPolicy != null) {
            return this.ringbuffer.getCapacity() - this.size();
        }
        return this.ringbuffer.getCapacity();
    }

    public long add(T item) {
        long sequence = this.addInternal(item);
        if (this.store.isEnabled()) {
            try {
                this.store.store(sequence, this.convertToData(item));
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        return sequence;
    }

    public long addAll(T[] items) {
        long firstSequence = -1L;
        long lastSequence = -1L;
        for (int i = 0; i < items.length; ++i) {
            lastSequence = this.addInternal(items[i]);
            if (i != 0) continue;
            firstSequence = lastSequence;
        }
        if (this.store.isEnabled() && items.length != 0) {
            try {
                this.store.storeAll(firstSequence, this.convertToData(items));
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        return lastSequence;
    }

    public void set(long sequenceId, T item) {
        Object rbItem = this.convertToRingbufferFormat(item);
        this.ringbuffer.set(sequenceId, rbItem);
        if (sequenceId > this.tailSequence()) {
            this.ringbuffer.setTailSequence(sequenceId);
            if (this.ringbuffer.size() > this.ringbuffer.getCapacity()) {
                this.ringbuffer.setHeadSequence(this.ringbuffer.tailSequence() - this.ringbuffer.getCapacity() + 1L);
            }
        }
        if (sequenceId < this.headSequence()) {
            this.ringbuffer.setHeadSequence(sequenceId);
        }
        if (this.expirationPolicy != null) {
            this.expirationPolicy.setExpirationAt(sequenceId);
        }
    }

    public Data readAsData(long sequence) {
        this.checkReadSequence(sequence);
        Object rbItem = this.readOrLoadItem(sequence);
        return this.serializationService.toData(rbItem);
    }

    public long readMany(long beginSequence, ReadResultSetImpl result) {
        long seq;
        this.checkReadSequence(beginSequence);
        for (seq = beginSequence; seq <= this.ringbuffer.tailSequence(); ++seq) {
            result.addItem(seq, this.readOrLoadItem(seq));
            if (!result.isMaxSizeReached()) continue;
            break;
        }
        return seq;
    }

    public void cleanup() {
        if (this.expirationPolicy != null) {
            this.expirationPolicy.cleanup(this.ringbuffer);
        }
    }

    public void checkBlockableReadSequence(long readSequence) {
        long tailSequence = this.ringbuffer.tailSequence();
        if (readSequence > tailSequence + 1L) {
            throw new IllegalArgumentException("sequence:" + readSequence + " is too large. The current tailSequence is:" + tailSequence);
        }
        long headSequence = this.ringbuffer.headSequence();
        if (readSequence < headSequence && !this.store.isEnabled()) {
            throw new StaleSequenceException("sequence:" + readSequence + " is too small and data store is disabled. " + "The current headSequence is:" + headSequence + " tailSequence is:" + tailSequence, headSequence);
        }
    }

    private void checkReadSequence(long sequence) {
        long tailSequence = this.ringbuffer.tailSequence();
        if (sequence > tailSequence) {
            throw new IllegalArgumentException("sequence:" + sequence + " is too large. The current tailSequence is:" + tailSequence);
        }
        long headSequence = this.ringbuffer.headSequence();
        if (sequence < headSequence && !this.store.isEnabled()) {
            throw new StaleSequenceException("sequence:" + sequence + " is too small and data store is disabled." + " The current headSequence is:" + headSequence + " tailSequence is:" + tailSequence, headSequence);
        }
    }

    private Object readOrLoadItem(long sequence) {
        Object item = sequence < this.ringbuffer.headSequence() && this.store.isEnabled() ? this.store.load(sequence) : this.ringbuffer.read(sequence);
        return item;
    }

    private long addInternal(T item) {
        Object rbItem = this.convertToRingbufferFormat(item);
        long tailSequence = this.ringbuffer.add(rbItem);
        if (this.expirationPolicy != null) {
            this.expirationPolicy.setExpirationAt(tailSequence);
        }
        return tailSequence;
    }

    private Object convertToRingbufferFormat(Object item) {
        return this.inMemoryFormat == InMemoryFormat.OBJECT ? this.serializationService.toObject(item) : this.serializationService.toData(item);
    }

    private Data convertToData(Object item) {
        return this.serializationService.toData(item);
    }

    private Data[] convertToData(T[] items) {
        if (items == null || items.length == 0) {
            return new Data[0];
        }
        if (items[0] instanceof Data) {
            return (Data[])items;
        }
        Data[] ret = new Data[items.length];
        for (int i = 0; i < items.length; ++i) {
            ret[i] = this.convertToData(items[i]);
        }
        return ret;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        boolean ttlEnabled;
        assert (!out.getVersion().isUnknown());
        boolean bl = ttlEnabled = this.expirationPolicy != null;
        if (!RingbufferContainer.isGreaterOrEqualV39(out)) {
            out.writeUTF(this.namespace.getObjectName());
        }
        out.writeLong(this.ringbuffer.tailSequence());
        out.writeLong(this.ringbuffer.headSequence());
        out.writeInt((int)this.ringbuffer.getCapacity());
        out.writeLong(ttlEnabled ? this.expirationPolicy.getTtlMs() : 0L);
        out.writeInt(this.inMemoryFormat.ordinal());
        long now = System.currentTimeMillis();
        for (long seq = this.ringbuffer.headSequence(); seq <= this.ringbuffer.tailSequence(); ++seq) {
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                out.writeData((Data)this.ringbuffer.read(seq));
            } else {
                out.writeObject(this.ringbuffer.read(seq));
            }
            if (!ttlEnabled) continue;
            long deltaMs = this.expirationPolicy.getExpirationAt(seq) - now;
            out.writeLong(deltaMs);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        boolean ttlEnabled;
        if (!RingbufferContainer.isGreaterOrEqualV39(in)) {
            in.readUTF();
        }
        long tailSequence = in.readLong();
        long headSequence = in.readLong();
        int capacity = in.readInt();
        long ttlMs = in.readLong();
        this.inMemoryFormat = InMemoryFormat.values()[in.readInt()];
        this.ringbuffer = new ArrayRingbuffer(capacity);
        this.ringbuffer.setTailSequence(tailSequence);
        this.ringbuffer.setHeadSequence(headSequence);
        boolean bl = ttlEnabled = ttlMs != 0L;
        if (ttlEnabled) {
            this.expirationPolicy = new RingbufferExpirationPolicy(capacity, ttlMs);
        }
        long now = System.currentTimeMillis();
        for (long seq = headSequence; seq <= tailSequence; ++seq) {
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                this.ringbuffer.set(seq, in.readData());
            } else {
                this.ringbuffer.set(seq, in.readObject());
            }
            if (!ttlEnabled) continue;
            long delta = in.readLong();
            this.expirationPolicy.setExpirationAt(seq, delta + now);
        }
    }

    private static boolean isGreaterOrEqualV39(VersionAware versionAware) {
        return versionAware.getVersion().isGreaterOrEqual(Versions.V3_9);
    }

    Ringbuffer getRingbuffer() {
        return this.ringbuffer;
    }

    RingbufferExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public ObjectNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public int getFactoryId() {
        return RingbufferDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.emptyRingWaitNotifyKey;
    }
}

