/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.partition.ReplicaErrorLogger;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Bits;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import java.nio.ByteOrder;

public final class InboundResponseHandler
implements PacketHandler,
MetricsProvider {
    private final ILogger logger;
    private final InternalSerializationService serializationService;
    private final InvocationRegistry invocationRegistry;
    private final NodeEngineImpl nodeEngine;
    @Probe(name="responses[normal]", level=ProbeLevel.MANDATORY)
    private final SwCounter responsesNormal = SwCounter.newSwCounter();
    @Probe(name="responses[timeout]", level=ProbeLevel.MANDATORY)
    private final SwCounter responsesTimeout = SwCounter.newSwCounter();
    @Probe(name="responses[backup]", level=ProbeLevel.MANDATORY)
    private final MwCounter responsesBackup = MwCounter.newMwCounter();
    @Probe(name="responses[error]", level=ProbeLevel.MANDATORY)
    private final SwCounter responsesError = SwCounter.newSwCounter();
    @Probe(name="responses[missing]", level=ProbeLevel.MANDATORY)
    private final MwCounter responsesMissing = MwCounter.newMwCounter();
    private final boolean useBigEndian;

    InboundResponseHandler(ILogger logger, InternalSerializationService serializationService, InvocationRegistry invocationRegistry, NodeEngineImpl nodeEngine) {
        this.logger = logger;
        this.useBigEndian = serializationService.getByteOrder() == ByteOrder.BIG_ENDIAN;
        this.serializationService = serializationService;
        this.invocationRegistry = invocationRegistry;
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void provideMetrics(MetricsRegistry registry) {
        registry.scanAndRegister(this, "operation.invocations");
    }

    @Override
    public void handle(Packet packet) throws Exception {
        byte[] bytes = packet.toByteArray();
        int typeId = Bits.readInt(bytes, 13, this.useBigEndian);
        long callId = Bits.readLong(bytes, 17, this.useBigEndian);
        Address sender = packet.getConn().getEndPoint();
        try {
            switch (typeId) {
                case 0: {
                    byte backupAcks = bytes[26];
                    this.notifyNormalResponse(callId, packet, backupAcks, sender);
                    break;
                }
                case 2: {
                    this.notifyBackupComplete(callId);
                    break;
                }
                case 8: {
                    this.notifyCallTimeout(callId, sender);
                    break;
                }
                case 9: {
                    ErrorResponse errorResponse = (ErrorResponse)this.serializationService.toObject(packet);
                    this.notifyErrorResponse(callId, errorResponse.getCause(), sender);
                    break;
                }
                default: {
                    this.logger.severe("Unrecognized type: " + typeId);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.logger.severe("While processing response...", e);
        }
    }

    public void notifyBackupComplete(long callId) {
        this.responsesBackup.inc();
        try {
            Invocation invocation = this.invocationRegistry.get(callId);
            if (invocation == null) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("No Invocation found for backup response with callId " + callId);
                }
                return;
            }
            invocation.notifyBackupComplete();
        }
        catch (Exception e) {
            ReplicaErrorLogger.log(e, this.logger);
        }
    }

    void notifyErrorResponse(long callId, Object cause, Address sender) {
        this.responsesError.inc();
        Invocation invocation = this.invocationRegistry.get(callId);
        if (invocation == null) {
            this.responsesMissing.inc();
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for error response with callId: " + callId + " sent from " + sender);
            }
            return;
        }
        invocation.notifyError(cause);
    }

    void notifyNormalResponse(long callId, Object value, int backupCount, Address sender) {
        this.responsesNormal.inc();
        Invocation invocation = this.invocationRegistry.get(callId);
        if (invocation == null) {
            this.responsesMissing.inc();
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for normal response with callId " + callId + " sent from " + sender);
            }
            return;
        }
        invocation.notifyNormalResponse(value, backupCount);
    }

    void notifyCallTimeout(long callId, Address sender) {
        this.responsesTimeout.inc();
        Invocation invocation = this.invocationRegistry.get(callId);
        if (invocation == null) {
            this.responsesMissing.inc();
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for call timeout response with callId" + callId + " sent from " + sender);
            }
            return;
        }
        invocation.notifyCallTimeout();
    }
}

