/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.operations;

import com.hazelcast.client.impl.operations.OperationFactoryWrapper;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareFactoryAccessor;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.util.CollectionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionIteratingOperation
extends Operation
implements IdentifiedDataSerializable {
    private static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };
    private static final PartitionResponse EMPTY_RESPONSE = new PartitionResponse(new int[0], new Object[0]);
    private OperationFactory operationFactory;
    private int[] partitions;

    public PartitionIteratingOperation() {
    }

    public PartitionIteratingOperation(OperationFactory operationFactory, List<Integer> partitions) {
        this.operationFactory = operationFactory;
        this.partitions = CollectionUtil.toIntArray(partitions);
    }

    public OperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public void run() throws Exception {
        if (this.partitions.length == 0) {
            this.sendResponse(EMPTY_RESPONSE);
            return;
        }
        this.getOperationServiceImpl().onStartAsyncOperation(this);
        PartitionAwareOperationFactory partitionAwareFactory = PartitionAwareFactoryAccessor.extractPartitionAware(this.operationFactory);
        if (partitionAwareFactory != null) {
            this.executePartitionAwareOperations(partitionAwareFactory);
        } else {
            this.executeOperations();
        }
    }

    @Override
    public void onExecutionFailure(Throwable cause) {
        try {
            this.sendResponse(new ErrorResponse(cause, this.getCallId(), this.isUrgent()));
        }
        finally {
            this.getOperationServiceImpl().onCompletionAsyncOperation(this);
        }
        this.getLogger().severe(cause);
    }

    private void executeOperations() {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationResponseHandlerImpl responseHandler = new OperationResponseHandlerImpl(this.partitions);
        OperationService operationService = nodeEngine.getOperationService();
        Object service = this.getServiceName() == null ? null : this.getService();
        for (int partitionId : this.partitions) {
            Operation operation = this.operationFactory.createOperation().setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(this.getReplicaIndex()).setOperationResponseHandler(responseHandler).setServiceName(this.getServiceName()).setService(service).setCallerUuid(this.extractCallerUuid());
            OperationAccessor.setCallerAddress(operation, this.getCallerAddress());
            operationService.execute(operation);
        }
    }

    private void executePartitionAwareOperations(PartitionAwareOperationFactory givenFactory) {
        PartitionAwareOperationFactory factory = givenFactory.createFactoryOnRunner(this.getNodeEngine());
        NodeEngine nodeEngine = this.getNodeEngine();
        int[] operationFactoryPartitions = factory.getPartitions();
        this.partitions = operationFactoryPartitions == null ? this.partitions : operationFactoryPartitions;
        OperationResponseHandlerImpl responseHandler = new OperationResponseHandlerImpl(this.partitions);
        OperationService operationService = nodeEngine.getOperationService();
        Object service = this.getServiceName() == null ? null : this.getService();
        for (int partitionId : this.partitions) {
            Operation op = factory.createPartitionOperation(partitionId).setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(this.getReplicaIndex()).setOperationResponseHandler(responseHandler).setServiceName(this.getServiceName()).setService(service).setCallerUuid(this.extractCallerUuid());
            OperationAccessor.setCallerAddress(op, this.getCallerAddress());
            operationService.execute(op);
        }
    }

    private OperationServiceImpl getOperationServiceImpl() {
        return (OperationServiceImpl)this.getNodeEngine().getOperationService();
    }

    private String extractCallerUuid() {
        if (this.operationFactory instanceof OperationFactoryWrapper) {
            return ((OperationFactoryWrapper)this.operationFactory).getUuid();
        }
        return this.getCallerUuid();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", operationFactory=").append(this.operationFactory);
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.operationFactory);
        out.writeIntArray(this.partitions);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.operationFactory = (OperationFactory)in.readObject();
        this.partitions = in.readIntArray();
    }

    public static final class PartitionResponse
    implements IdentifiedDataSerializable {
        private int[] partitions;
        private Object[] results;

        public PartitionResponse() {
        }

        PartitionResponse(int[] partitions, Object[] results) {
            this.partitions = partitions;
            this.results = results;
        }

        public void addResults(Map<Integer, Object> partitionResults) {
            if (this.results == null) {
                return;
            }
            for (int i = 0; i < this.results.length; ++i) {
                partitionResults.put(this.partitions[i], this.results[i]);
            }
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Object[] getResults() {
            return this.results;
        }

        @Override
        public int getFactoryId() {
            return SpiDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 4;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeIntArray(this.partitions);
            int resultLength = this.results != null ? this.results.length : 0;
            out.writeInt(resultLength);
            if (resultLength > 0) {
                for (Object result : this.results) {
                    out.writeObject(result);
                }
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.partitions = in.readIntArray();
            int resultLength = in.readInt();
            if (resultLength > 0) {
                this.results = new Object[resultLength];
                for (int i = 0; i < resultLength; ++i) {
                    this.results[i] = in.readObject();
                }
            }
        }
    }

    private class OperationResponseHandlerImpl
    implements OperationResponseHandler {
        private final AtomicReferenceArray<Object> responseArray;
        private final AtomicInteger pendingOperations;
        private final int[] partitions;

        OperationResponseHandlerImpl(int[] partitions) {
            this.responseArray = new AtomicReferenceArray(PartitionIteratingOperation.this.getNodeEngine().getPartitionService().getPartitionCount());
            this.partitions = partitions;
            this.pendingOperations = new AtomicInteger(partitions.length);
        }

        public void sendResponse(Operation op, Object response) {
            if (response instanceof NormalResponse) {
                response = ((NormalResponse)response).getValue();
            } else if (response == null) {
                response = NULL;
            }
            if (!this.responseArray.compareAndSet(op.getPartitionId(), null, response)) {
                PartitionIteratingOperation.this.getLogger().warning("Duplicate response for " + op + " second response [" + response + "]" + "first response [" + this.responseArray.get(op.getPartitionId()) + "]");
                return;
            }
            if (this.pendingOperations.decrementAndGet() == 0) {
                try {
                    this.sendResponse();
                }
                finally {
                    PartitionIteratingOperation.this.getOperationServiceImpl().onCompletionAsyncOperation(PartitionIteratingOperation.this);
                }
            }
        }

        private void sendResponse() {
            Object[] results = new Object[this.partitions.length];
            for (int k = 0; k < this.partitions.length; ++k) {
                int partitionId = this.partitions[k];
                Object response = this.responseArray.get(partitionId);
                results[k] = response == NULL ? null : response;
            }
            PartitionIteratingOperation.this.sendResponse(new PartitionResponse(this.partitions, results));
        }
    }
}

