/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.sequence;

import com.hazelcast.spi.impl.sequence.CallIdSequence;
import com.hazelcast.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.util.concurrent.IdleStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLongArray;

public final class CallIdSequenceWithBackpressure
implements CallIdSequence {
    static final int MAX_DELAY_MS = 500;
    private static final IdleStrategy IDLER = new BackoffIdleStrategy(0L, 0L, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.MILLISECONDS.toNanos(500L));
    private static final int INDEX_HEAD = 7;
    private static final int INDEX_TAIL = 15;
    private final AtomicLongArray longs = new AtomicLongArray(24);
    private final int maxConcurrentInvocations;
    private final long backoffTimeoutNanos;

    public CallIdSequenceWithBackpressure(int maxConcurrentInvocations, long backoffTimeoutMs) {
        this.maxConcurrentInvocations = maxConcurrentInvocations;
        this.backoffTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(backoffTimeoutMs);
    }

    @Override
    public long getLastCallId() {
        return this.longs.get(7);
    }

    @Override
    public int getMaxConcurrentInvocations() {
        return this.maxConcurrentInvocations;
    }

    @Override
    public long next() throws TimeoutException {
        if (!this.hasSpace()) {
            this.waitForSpace();
        }
        return this.forceNext();
    }

    @Override
    public void complete() {
        long newTail = this.longs.incrementAndGet(15);
        assert (newTail <= this.longs.get(7));
    }

    @Override
    public long forceNext() {
        return this.longs.incrementAndGet(7);
    }

    long getTail() {
        return this.longs.get(15);
    }

    private boolean hasSpace() {
        return this.longs.get(7) - this.longs.get(15) < (long)this.maxConcurrentInvocations;
    }

    private void waitForSpace() throws TimeoutException {
        long deadline = System.nanoTime() + this.backoffTimeoutNanos;
        long idleCount = 0L;
        while (true) {
            if (System.nanoTime() >= deadline) {
                throw new TimeoutException(String.format("Timed out trying to acquire another call ID. maxConcurrentInvocations = %d, backoffTimeout = %d", this.maxConcurrentInvocations, TimeUnit.NANOSECONDS.toMillis(this.backoffTimeoutNanos)));
            }
            IDLER.idle(idleCount);
            if (this.hasSpace()) {
                return;
            }
            ++idleCount;
        }
    }
}

