/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.version;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.StringUtil;
import java.io.IOException;

public final class Version
implements IdentifiedDataSerializable,
Comparable<Version> {
    public static final byte UNKNOWN_VERSION = 0;
    public static final Version UNKNOWN = new Version(0, 0);
    private byte major;
    private byte minor;

    public Version() {
    }

    private Version(int major, int minor) {
        this.major = (byte)major;
        this.minor = (byte)minor;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        if (this.major != that.major) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.major);
        out.writeByte(this.minor);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.major = in.readByte();
        this.minor = in.readByte();
    }

    @Override
    public int compareTo(Version o) {
        int thatVersion;
        int thisVersion = this.pack();
        if (thisVersion > (thatVersion = o.pack())) {
            return 1;
        }
        return thisVersion == thatVersion ? 0 : -1;
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 35;
    }

    public static Version of(int major, int minor) {
        if (major == 0 && minor == 0) {
            return UNKNOWN;
        }
        return new Version(major, minor);
    }

    public static Version of(String version) {
        String[] tokens = StringUtil.tokenizeVersionString(version);
        if (tokens != null && tokens.length >= 2) {
            return Version.of(Byte.valueOf(tokens[0]).byteValue(), Byte.valueOf(tokens[1]).byteValue());
        }
        throw new IllegalArgumentException("Cannot parse " + version + " to ClusterVersion.");
    }

    public boolean isEqualTo(Version version) {
        return this.equals(version);
    }

    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isUnknownOrGreaterThan(Version version) {
        return this.isUnknown() || this.compareTo(version) > 0;
    }

    public boolean isGreaterOrEqual(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isUnknownGreaterOrEqual(Version version) {
        return this.isUnknown() || this.compareTo(version) >= 0;
    }

    public boolean isLessThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isUnknownOrLessThan(Version version) {
        return this.isUnknown() || this.compareTo(version) < 0;
    }

    public boolean isLessOrEqual(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isUnknownLessOrEqual(Version version) {
        return this.isUnknown() || this.compareTo(version) <= 0;
    }

    public boolean isBetween(Version from, Version to) {
        int thisVersion = this.pack();
        int fromVersion = from.pack();
        int toVersion = to.pack();
        return thisVersion >= fromVersion && thisVersion <= toVersion;
    }

    public boolean isUnknown() {
        return this.equals(UNKNOWN);
    }

    private int pack() {
        return this.major << 8 & 0xFF00 | this.minor & 0xFF;
    }
}

