/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClientStateListener
implements LifecycleListener {
    private LifecycleEvent.LifecycleState currentState = LifecycleEvent.LifecycleState.STARTING;
    private final Lock lock = new ReentrantLock();
    private final Condition connectedCondition = this.lock.newCondition();
    private final Condition disconnectedCondition = this.lock.newCondition();

    public ClientStateListener(ClientConfig clientConfig) {
        clientConfig.addListenerConfig(new ListenerConfig(this));
    }

    @Override
    public void stateChanged(LifecycleEvent event) {
        this.lock.lock();
        try {
            this.currentState = event.getState();
            if (this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTTING_DOWN) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTDOWN)) {
                this.connectedCondition.signalAll();
            } else if (this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTTING_DOWN) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTDOWN)) {
                this.disconnectedCondition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitConnected(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                boolean bl = true;
                return bl;
            }
            if (this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTTING_DOWN) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTDOWN)) {
                boolean bl = false;
                return bl;
            }
            long duration = unit.toNanos(timeout);
            while (duration > 0L) {
                duration = this.connectedCondition.awaitNanos(duration);
                if (!this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean awaitConnected() throws InterruptedException {
        return this.awaitConnected(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitDisconnected(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTTING_DOWN) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTDOWN)) {
                boolean bl = true;
                return bl;
            }
            long duration = unit.toNanos(timeout);
            while (duration > 0L) {
                duration = this.disconnectedCondition.awaitNanos(duration);
                if (!this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) && !this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTTING_DOWN) && !this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTDOWN)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean awaitDisconnected() throws InterruptedException {
        return this.awaitDisconnected(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean isConnected() {
        this.lock.lock();
        try {
            boolean bl = this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.currentState.equals((Object)LifecycleEvent.LifecycleState.SHUTDOWN);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isStarted() {
        this.lock.lock();
        try {
            boolean bl = this.currentState.equals((Object)LifecycleEvent.LifecycleState.STARTED) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED) || this.currentState.equals((Object)LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public LifecycleEvent.LifecycleState getCurrentState() {
        this.lock.lock();
        try {
            LifecycleEvent.LifecycleState lifecycleState = this.currentState;
            return lifecycleState;
        }
        finally {
            this.lock.unlock();
        }
    }
}

