/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.ReplicationEventObject;
import com.hazelcast.wan.impl.WanDataSerializerHook;
import com.hazelcast.wan.impl.WanEventCounter;
import java.io.IOException;

public class MapReplicationUpdate
implements ReplicationEventObject,
IdentifiedDataSerializable {
    private String mapName;
    private MapMergePolicy mergePolicy;
    private EntryView<Data, Data> entryView;

    public MapReplicationUpdate() {
    }

    public MapReplicationUpdate(String mapName, MapMergePolicy mergePolicy, EntryView<Data, Data> entryView) {
        this.mergePolicy = mergePolicy;
        this.mapName = mapName;
        this.entryView = entryView;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public MapMergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public void setMergePolicy(MapMergePolicy mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public EntryView getEntryView() {
        return this.entryView;
    }

    public void setEntryView(EntryView<Data, Data> entryView) {
        this.entryView = entryView;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeObject(this.mergePolicy);
        out.writeObject(this.entryView);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.mergePolicy = (MapMergePolicy)in.readObject();
        this.entryView = (EntryView)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void incrementEventCount(WanEventCounter eventCounter) {
        eventCounter.incrementUpdate(this.mapName);
    }

    @Override
    public Data getKey() {
        return this.entryView.getKey();
    }
}

