/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.batching;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.batching.PartitionAwareCallable;
import com.hazelcast.spi.impl.operationservice.impl.batching.PartitionAwareCallableFactory;
import com.hazelcast.spi.partition.IPartition;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionAwareCallableBatchingRunnable
implements Runnable {
    private final PartitionAwareCallableFactory factory;
    private final IPartitionService partitionService;
    private final int partitionThreadCount;
    private final CopyOnWriteArrayList results = new CopyOnWriteArrayList();
    private final AtomicInteger finished = new AtomicInteger(0);
    private final ResultFuture future;

    public PartitionAwareCallableBatchingRunnable(NodeEngine nodeEngine, PartitionAwareCallableFactory factory) {
        this.factory = factory;
        this.partitionService = nodeEngine.getPartitionService();
        this.partitionThreadCount = ((OperationServiceImpl)nodeEngine.getOperationService()).getPartitionThreadCount();
        this.future = new ResultFuture(nodeEngine, nodeEngine.getLogger(this.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadUtil.assertRunningOnPartitionThread();
        PartitionOperationThread currentThread = (PartitionOperationThread)Thread.currentThread();
        int currentPartitionId = currentThread.getThreadId();
        try {
            IPartition[] partitions = this.partitionService.getPartitions();
            this.runSequentially(currentThread, currentPartitionId, partitions);
        }
        finally {
            int value = this.finished.incrementAndGet();
            if (!this.future.isDone() && value == this.partitionThreadCount) {
                this.future.setResult(this.results);
            }
        }
    }

    private void runSequentially(PartitionOperationThread currentThread, int fromPartitionId, IPartition[] partitions) {
        for (int currentPartitionId = fromPartitionId; currentPartitionId < partitions.length; currentPartitionId += this.partitionThreadCount) {
            if (this.future.isDone()) {
                return;
            }
            IPartition partition = partitions[currentPartitionId];
            if (currentThread.isInterrupted()) {
                this.future.cancel(true);
                break;
            }
            PartitionAwareCallable task = this.factory.create();
            if (!partition.isLocal() || partition.isMigrating()) continue;
            try {
                this.results.add(task.call(currentPartitionId));
                continue;
            }
            catch (Exception ex) {
                this.future.setResult(ex);
                break;
            }
        }
    }

    public ICompletableFuture getFuture() {
        return this.future;
    }

    private static class ResultFuture
    extends AbstractCompletableFuture {
        ResultFuture(NodeEngine nodeEngine, ILogger logger) {
            super(nodeEngine, logger);
        }

        @Override
        protected void setResult(Object result) {
            super.setResult(result);
        }
    }
}

