/*
 * Copyright (c) 2008-2019, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.PreJoinCacheConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;

import java.io.IOException;

public class AddCacheConfigOperation extends Operation implements IdentifiedDataSerializable {

    private PreJoinCacheConfig cacheConfig;

    public AddCacheConfigOperation() {
    }

    public AddCacheConfigOperation(PreJoinCacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    @Override
    public void run() {
        ICacheService cacheService = getService();
        cacheService.setTenantControl(cacheConfig);
        cacheService.putCacheConfigIfAbsent(cacheConfig);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(cacheConfig);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        cacheConfig = in.readObject();
    }

    @Override
    public String getServiceName() {
        return ICacheService.SERVICE_NAME;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return CacheDataSerializerHook.ADD_CACHE_CONFIG_OPERATION;
    }


}
