/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.partition.IPartitionService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheException;
import javax.cache.integration.CompletionListener;

final class CacheProxyLoadAllTask
implements Runnable {
    private static final double SIZING_FUDGE_FACTOR = 1.3;
    private final NodeEngine nodeEngine;
    private final CompletionListener completionListener;
    private final CacheOperationProvider operationProvider;
    private final Set<Data> keysData;
    private final boolean replaceExistingValues;
    private final String serviceName;

    CacheProxyLoadAllTask(NodeEngine nodeEngine, CacheOperationProvider operationProvider, Set<Data> keysData, boolean replaceExistingValues, CompletionListener completionListener, String serviceName) {
        this.nodeEngine = nodeEngine;
        this.operationProvider = operationProvider;
        this.keysData = keysData;
        this.replaceExistingValues = replaceExistingValues;
        this.completionListener = completionListener;
        this.serviceName = serviceName;
    }

    @Override
    public void run() {
        block7: {
            try {
                this.injectDependencies(this.completionListener);
                OperationService operationService = this.nodeEngine.getOperationService();
                IPartitionService partitionService = this.nodeEngine.getPartitionService();
                Map<Address, List<Integer>> memberPartitionsMap = partitionService.getMemberPartitionsMap();
                int partitionCount = partitionService.getPartitionCount();
                Map<Integer, Object> results = MapUtil.createHashMap(partitionCount);
                for (Map.Entry<Address, List<Integer>> memberPartitions : memberPartitionsMap.entrySet()) {
                    PartitionIdSet partitions = new PartitionIdSet(partitionCount, (Collection<Integer>)memberPartitions.getValue());
                    Set<Data> ownerKeys = this.filterOwnerKeys(partitionService, partitions);
                    OperationFactory operationFactory = this.operationProvider.createLoadAllOperationFactory(ownerKeys, this.replaceExistingValues);
                    Map memberResults = operationService.invokeOnPartitions(this.serviceName, operationFactory, partitions);
                    results.putAll(memberResults);
                }
                CacheProxyUtil.validateResults(results);
                if (this.completionListener != null) {
                    this.completionListener.onCompletion();
                }
            }
            catch (Exception e) {
                if (this.completionListener != null) {
                    this.completionListener.onException(e);
                }
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    throw ExceptionUtil.rethrow(t);
                }
                if (this.completionListener == null) break block7;
                this.completionListener.onException((Exception)new CacheException(t));
            }
        }
    }

    private void injectDependencies(Object obj) {
        ManagedContext managedContext = this.nodeEngine.getSerializationService().getManagedContext();
        managedContext.initialize(obj);
    }

    private Set<Data> filterOwnerKeys(IPartitionService partitionService, Set<Integer> partitions) {
        int roughSize = (int)((double)(this.keysData.size() * partitions.size()) / (double)partitionService.getPartitionCount() * 1.3);
        Set<Data> ownerKeys = SetUtil.createHashSet(roughSize);
        for (Data key : this.keysData) {
            int keyPartitionId = partitionService.getPartitionId(key);
            if (!partitions.contains(keyPartitionId)) continue;
            ownerKeys.add(key);
        }
        return ownerKeys;
    }
}

