/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cardinality.impl;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.cardinality.impl.CardinalityEstimatorService;
import com.hazelcast.cardinality.impl.operations.AggregateOperation;
import com.hazelcast.cardinality.impl.operations.EstimateOperation;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;

public class CardinalityEstimatorProxy
extends AbstractDistributedObject<CardinalityEstimatorService>
implements CardinalityEstimator {
    private final String name;
    private final int partitionId;

    CardinalityEstimatorProxy(String name, NodeEngine nodeEngine, CardinalityEstimatorService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cardinalityEstimatorService";
    }

    @Override
    public void add(Object obj) {
        ((AbstractInvocationFuture)this.addAsync(obj)).joinInternal();
    }

    @Override
    public long estimate() {
        return (Long)((AbstractInvocationFuture)this.estimateAsync()).joinInternal();
    }

    public InvocationFuture<Void> addAsync(Object obj) {
        Preconditions.checkNotNull(obj, "Object is null.");
        Object data = this.getNodeEngine().getSerializationService().toData(obj);
        Operation operation = new AggregateOperation(this.name, data.hash64()).setPartitionId(this.partitionId);
        return this.invokeOnPartition(operation);
    }

    public InvocationFuture<Long> estimateAsync() {
        Operation operation = new EstimateOperation(this.name).setPartitionId(this.partitionId);
        return this.invokeOnPartition(operation);
    }

    @Override
    public String toString() {
        return "CardinalityEstimator{name='" + this.name + '\'' + '}';
    }
}

