/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.ClientCacheProxySupportUtil;
import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.ClientInterceptingDelegatingFuture;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;

public class NearCachedClientCacheProxy<K, V>
extends ClientCacheProxy<K, V> {
    private boolean cacheOnUpdate;
    private boolean invalidateOnChange;
    private boolean serializeKeys;
    private NearCacheManager nearCacheManager;
    private NearCache<Object, Object> nearCache;
    private UUID nearCacheMembershipRegistrationId;

    NearCachedClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super(cacheConfig, context);
    }

    public NearCache getNearCache() {
        return this.nearCache;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ClientConfig clientConfig = this.getContext().getClientConfig();
        NearCacheConfig nearCacheConfig = ClientCacheProxySupportUtil.checkNearCacheConfig(clientConfig.getNearCacheConfig(this.name), clientConfig.getNativeMemoryConfig());
        this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE;
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.serializeKeys = nearCacheConfig.isSerializeKeys();
        ICacheDataStructureAdapter adapter = new ICacheDataStructureAdapter(this);
        this.nearCacheManager = this.getContext().getNearCacheManager();
        this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, adapter);
        CacheStatistics localCacheStatistics = super.getLocalCacheStatistics();
        ((ClientCacheStatisticsImpl)localCacheStatistics).setNearCacheStats(this.nearCache.getNearCacheStats());
        this.registerInvalidationListener();
    }

    @Override
    protected V getSyncInternal(Object key, ExpiryPolicy expiryPolicy) {
        key = this.serializeKeys ? this.toData(key) : key;
        Object value = this.getCachedValue(key, true);
        if (value != NearCache.NOT_CACHED) {
            return (V)value;
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData);
            value = super.getSyncInternal(keyData, expiryPolicy);
            if (reservationId != -1L) {
                value = this.tryPublishReserved(key, value, reservationId);
            }
            return (V)value;
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    protected InternalCompletableFuture<V> getAsyncInternal(Object key, ExpiryPolicy expiryPolicy, BiConsumer<V, Throwable> callback) {
        key = this.serializeKeys ? this.toData(key) : key;
        Object value = this.getCachedValue(key, false);
        if (value != NearCache.NOT_CACHED) {
            return InternalCompletableFuture.newCompletedFuture(value);
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData);
            GetAsyncCallback getAsyncCallback = new GetAsyncCallback(key, reservationId, callback);
            return super.getAsyncInternal(keyData, expiryPolicy, getAsyncCallback);
        }
        catch (Throwable t) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPutSyncInternal(K key, V value, Data keyData, Data valueData) {
        try {
            super.onPutSyncInternal(key, value, keyData, valueData);
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
        }
        catch (Throwable throwable) {
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPutIfAbsentSyncInternal(K key, V value, Data keyData, Data valueData) {
        try {
            super.onPutIfAbsentSyncInternal(key, value, keyData, valueData);
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
        }
        catch (Throwable throwable) {
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
            throw throwable;
        }
    }

    @Override
    protected void onPutIfAbsentAsyncInternal(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<Boolean> delegatingFuture, BiConsumer<Boolean, Throwable> callback) {
        Data callbackKey = this.serializeKeys ? keyData : key;
        CacheOrInvalidateCallback<Boolean> wrapped = new CacheOrInvalidateCallback<Boolean>(callbackKey, keyData, value, valueData, callback);
        super.onPutIfAbsentAsyncInternal(key, value, keyData, valueData, delegatingFuture, wrapped);
    }

    @Override
    protected ClientDelegatingFuture<V> wrapPutAsyncFuture(K key, V value, Data keyData, Data valueData, ClientInvocationFuture invocationFuture, BiConsumer<V, Throwable> callback) {
        Data callbackKey = this.serializeKeys ? keyData : key;
        PutAsyncOneShotCallback wrapped = new PutAsyncOneShotCallback(callbackKey, keyData, value, valueData, callback);
        ClientInterceptingDelegatingFuture future = new ClientInterceptingDelegatingFuture(invocationFuture, this.getSerializationService(), message -> CachePutCodec.decodeResponse((ClientMessage)message).response, wrapped);
        future.whenCompleteAsync((BiConsumer)wrapped);
        return future;
    }

    @Override
    protected <T> void onGetAndRemoveAsyncInternal(K key, Data keyData, ClientDelegatingFuture<T> delegatingFuture, BiConsumer<T, Throwable> callback) {
        Data callbackKey = this.serializeKeys ? keyData : key;
        InvalidateCallback<T> wrapped = new InvalidateCallback<T>(callbackKey, callback);
        super.onGetAndRemoveAsyncInternal(key, keyData, delegatingFuture, wrapped);
    }

    @Override
    protected <T> void onReplaceInternalAsync(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<T> delegatingFuture, BiConsumer<T, Throwable> callback) {
        Data callbackKey = this.serializeKeys ? keyData : key;
        CacheOrInvalidateCallback<T> wrapped = new CacheOrInvalidateCallback<T>(callbackKey, keyData, value, valueData, callback);
        super.onReplaceInternalAsync(key, value, keyData, valueData, delegatingFuture, wrapped);
    }

    @Override
    protected <T> void onReplaceAndGetAsync(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<T> delegatingFuture, BiConsumer<T, Throwable> callback) {
        Data callbackKey = this.serializeKeys ? keyData : key;
        CacheOrInvalidateCallback<T> wrapped = new CacheOrInvalidateCallback<T>(callbackKey, keyData, value, valueData, callback);
        super.onReplaceAndGetAsync(key, value, keyData, valueData, delegatingFuture, wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getAllInternal(Set<? extends K> keys, Collection<Data> dataKeys, ExpiryPolicy expiryPolicy, List<Object> resultingKeyValuePairs, long startNanos) {
        if (this.serializeKeys) {
            this.toDataKeysWithReservations(keys, (Collection<Data>)dataKeys, null, null);
        }
        LinkedList<K> ncKeys = this.serializeKeys ? dataKeys : new LinkedList<K>(keys);
        this.populateResultFromNearCache(ncKeys, resultingKeyValuePairs);
        if (ncKeys.isEmpty()) {
            return;
        }
        Map<Object, Long> reservations = MapUtil.createHashMap(ncKeys.size());
        Map<Data, Object> reverseKeyMap = null;
        if (!this.serializeKeys) {
            reverseKeyMap = MapUtil.createHashMap(ncKeys.size());
            this.toDataKeysWithReservations(ncKeys, dataKeys, reservations, reverseKeyMap);
        } else {
            this.createNearCacheReservations(ncKeys, reservations);
        }
        try {
            int currentSize = resultingKeyValuePairs.size();
            super.getAllInternal(keys, dataKeys, expiryPolicy, resultingKeyValuePairs, startNanos);
            this.populateResultFromRemote(currentSize, resultingKeyValuePairs, reservations, reverseKeyMap);
        }
        finally {
            this.releaseRemainingReservedKeys(reservations);
        }
    }

    private void toDataKeysWithReservations(Collection<?> keys, Collection<Data> dataKeys, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (Object key : keys) {
            long reservationId;
            Data keyData = this.toData(key);
            if (reservations != null && (reservationId = this.tryReserveForUpdate(key, keyData)) != -1L) {
                reservations.put(key, reservationId);
            }
            if (reverseKeyMap != null) {
                reverseKeyMap.put(keyData, key);
            }
            dataKeys.add(keyData);
        }
    }

    private void populateResultFromNearCache(Collection<?> keys, List<Object> resultingKeyValuePairs) {
        Iterator<?> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object cached = this.getCachedValue(key, true);
            if (cached == NearCache.NOT_CACHED) continue;
            resultingKeyValuePairs.add(key);
            resultingKeyValuePairs.add(cached);
            iterator.remove();
        }
    }

    private void createNearCacheReservations(Collection<Data> dataKeys, Map<Object, Long> reservations) {
        for (Data key : dataKeys) {
            long reservationId = this.tryReserveForUpdate(key, key);
            if (reservationId == -1L) continue;
            reservations.put(key, reservationId);
        }
    }

    private void populateResultFromRemote(int currentSize, List<Object> resultingKeyValuePairs, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (int i = currentSize; i < resultingKeyValuePairs.size(); i += 2) {
            Long reservationId;
            Data ncKey;
            Data keyData = (Data)resultingKeyValuePairs.get(i);
            Data valueData = (Data)resultingKeyValuePairs.get(i + 1);
            Data data = ncKey = this.serializeKeys ? keyData : reverseKeyMap.get(keyData);
            if (!this.serializeKeys) {
                resultingKeyValuePairs.set(i, ncKey);
            }
            if ((reservationId = reservations.get(ncKey)) == null) continue;
            Object cachedValue = this.tryPublishReserved(ncKey, valueData, reservationId);
            resultingKeyValuePairs.set(i + 1, cachedValue);
            reservations.remove(ncKey);
        }
    }

    @Override
    public void setExpiryPolicyInternal(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        HashSet<Data> serializedKeys = null;
        if (this.serializeKeys) {
            serializedKeys = new HashSet<Data>(keys.size());
        }
        super.setExpiryPolicyInternal(keys, expiryPolicy, serializedKeys);
        this.invalidate(keys, serializedKeys);
    }

    @Override
    protected boolean setExpiryPolicyInternal(K key, ExpiryPolicy expiryPolicy) {
        boolean result = super.setExpiryPolicyInternal(key, expiryPolicy);
        if (this.serializeKeys) {
            this.invalidateNearCache(this.toData(key));
        } else {
            this.invalidateNearCache(key);
        }
        return result;
    }

    @Override
    protected void putAllInternal(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition, long startNanos) {
        try {
            if (!this.serializeKeys) {
                keyMap = MapUtil.createHashMap(map.size());
            }
            super.putAllInternal(map, expiryPolicy, keyMap, entriesPerPartition, startNanos);
            this.cacheOrInvalidate(map, keyMap, entriesPerPartition, true);
        }
        catch (Throwable t) {
            this.cacheOrInvalidate(map, keyMap, entriesPerPartition, false);
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void invalidate(Set<? extends K> keys, Set<Data> keysData) {
        if (this.serializeKeys) {
            for (Data key : keysData) {
                this.invalidateNearCache(key);
            }
        } else {
            for (K key : keys) {
                this.invalidateNearCache(key);
            }
        }
    }

    private void cacheOrInvalidate(Map<? extends K, ? extends V> map, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition, boolean isCacheOrInvalidate) {
        if (this.serializeKeys) {
            for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
                List<Map.Entry<Data, Data>> entries = entriesPerPartition[partitionId];
                if (entries == null) continue;
                for (Map.Entry<Data, Data> entry : entries) {
                    Data key = entry.getKey();
                    if (isCacheOrInvalidate) {
                        this.cacheOrInvalidate(key, key, null, entry.getValue());
                        continue;
                    }
                    this.invalidateNearCache(key);
                }
            }
        } else {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                if (isCacheOrInvalidate) {
                    this.cacheOrInvalidate(key, keyMap.get(key), entry.getValue(), null);
                    continue;
                }
                this.invalidateNearCache(key);
            }
        }
    }

    @Override
    protected boolean containsKeyInternal(Object key) {
        key = this.serializeKeys ? this.toData(key) : key;
        Object cached = this.getCachedValue(key, false);
        if (cached != NearCache.NOT_CACHED) {
            return cached != null;
        }
        return super.containsKeyInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadAllInternal(Set<? extends K> keys, List<Data> dataKeys, boolean replaceExistingValues, CompletionListener completionListener) {
        try {
            super.loadAllInternal(keys, dataKeys, replaceExistingValues, completionListener);
        }
        finally {
            if (this.serializeKeys) {
                for (Data dataKey : dataKeys) {
                    this.invalidateNearCache(dataKey);
                }
            } else {
                for (K key : keys) {
                    this.invalidateNearCache(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeAllKeysInternal(Set<? extends K> keys, Collection<Data> dataKeys, long startNanos) {
        try {
            super.removeAllKeysInternal(keys, dataKeys, startNanos);
        }
        finally {
            if (this.serializeKeys) {
                for (Data dataKey : dataKeys) {
                    this.invalidateNearCache(dataKey);
                }
            } else {
                for (K key : keys) {
                    this.invalidateNearCache(key);
                }
            }
        }
    }

    @Override
    public void onRemoveSyncInternal(Object key, Data keyData) {
        try {
            super.onRemoveSyncInternal(key, keyData);
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRemoveAsyncInternal(Object key, Data keyData, ClientDelegatingFuture future, BiConsumer<Object, Throwable> callback) {
        try {
            super.onRemoveAsyncInternal(key, keyData, future, callback);
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
            throw throwable;
        }
    }

    @Override
    public void removeAll() {
        try {
            super.removeAll();
        }
        finally {
            this.nearCache.clear();
        }
    }

    @Override
    public void clear() {
        try {
            super.clear();
        }
        finally {
            this.nearCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeInternal(Object key, Data epData, Object[] arguments) {
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            Object object = super.invokeInternal(key, epData, arguments);
            return object;
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    @Override
    public void close() {
        this.removeInvalidationListener();
        this.nearCacheManager.clearNearCache(this.nearCache.getName());
        super.close();
    }

    @Override
    protected void postDestroy() {
        try {
            this.removeInvalidationListener();
            this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        }
        finally {
            super.postDestroy();
        }
    }

    private Object getCachedValue(Object key, boolean deserializeValue) {
        Object cached = this.nearCache.get(key);
        assert (cached != NearCache.CACHED_AS_NULL);
        if (cached == null) {
            return NearCache.NOT_CACHED;
        }
        return deserializeValue ? this.toObject(cached) : cached;
    }

    private void cacheOrInvalidate(Object key, Data keyData, V value, Data valueData) {
        if (this.cacheOnUpdate) {
            this.nearCache.put(key, keyData, value, valueData);
        } else {
            this.invalidateNearCache(key);
        }
    }

    private void invalidateNearCache(Object key) {
        assert (key != null);
        this.nearCache.invalidate(key);
    }

    private long tryReserveForUpdate(Object key, Data keyData) {
        return this.nearCache.tryReserveForUpdate(key, keyData);
    }

    private Object tryPublishReserved(Object key, Object remoteValue, long reservationId, boolean deserialize) {
        assert (remoteValue != NearCache.NOT_CACHED);
        if (remoteValue == null) {
            this.invalidateNearCache(key);
            return null;
        }
        Object cachedValue = null;
        if (reservationId != -1L) {
            cachedValue = this.nearCache.tryPublishReserved(key, remoteValue, reservationId, deserialize);
        }
        return cachedValue == null ? remoteValue : cachedValue;
    }

    private Object tryPublishReserved(Object key, Object remoteValue, long reservationId) {
        return this.tryPublishReserved(key, remoteValue, reservationId, true);
    }

    private void releaseRemainingReservedKeys(Map<Object, Long> reservedKeys) {
        for (Object key : reservedKeys.keySet()) {
            this.nearCache.invalidate(key);
        }
    }

    public UUID addNearCacheInvalidationListener(EventHandler eventHandler) {
        return this.registerListener(ClientCacheProxySupportUtil.createInvalidationListenerCodec(this.nameWithPrefix), eventHandler);
    }

    private void registerInvalidationListener() {
        if (!this.invalidateOnChange) {
            return;
        }
        NearCacheInvalidationEventHandler eventHandler = new NearCacheInvalidationEventHandler();
        this.nearCacheMembershipRegistrationId = this.addNearCacheInvalidationListener(eventHandler);
    }

    private void removeInvalidationListener() {
        if (!this.invalidateOnChange) {
            return;
        }
        UUID registrationId = this.nearCacheMembershipRegistrationId;
        if (registrationId != null) {
            this.getContext().getRepairingTask(this.getServiceName()).deregisterHandler(this.nameWithPrefix);
            this.getContext().getListenerService().deregisterListener(registrationId);
        }
    }

    private final class NearCacheInvalidationEventHandler
    extends CacheAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private volatile RepairingHandler repairingHandler;

        private NearCacheInvalidationEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            RepairingTask repairingTask = NearCachedClientCacheProxy.this.getContext().getRepairingTask(NearCachedClientCacheProxy.this.getServiceName());
            this.repairingHandler = repairingTask.registerAndGetHandler(NearCachedClientCacheProxy.this.nameWithPrefix, NearCachedClientCacheProxy.this.nearCache);
        }

        @Override
        public void onListenerRegister() {
        }

        @Override
        public void handleCacheInvalidationEvent(String name, Data key, UUID sourceUuid, UUID partitionUuid, long sequence) {
            this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        @Override
        public void handleCacheBatchInvalidationEvent(String name, Collection<Data> keys, Collection<UUID> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }
    }

    private final class InvalidateCallback<T>
    implements BiConsumer<T, Throwable> {
        private final Object key;
        private final BiConsumer<T, Throwable> delegate;

        InvalidateCallback(Object key, BiConsumer<T, Throwable> delegate) {
            this.key = key;
            this.delegate = delegate;
        }

        @Override
        public void accept(T value, Throwable throwable) {
            try {
                if (this.delegate != null) {
                    this.delegate.accept(value, throwable);
                }
            }
            finally {
                NearCachedClientCacheProxy.this.invalidateNearCache(this.key);
            }
        }
    }

    private final class CacheOrInvalidateCallback<T>
    implements BiConsumer<T, Throwable> {
        private final Object key;
        private final Data keyData;
        private final V value;
        private final Data valueData;
        private final BiConsumer<T, Throwable> delegate;

        CacheOrInvalidateCallback(Object key, Data keyData, V value, Data valueData, BiConsumer<T, Throwable> delegate) {
            this.key = key;
            this.keyData = keyData;
            this.value = value;
            this.valueData = valueData;
            this.delegate = delegate;
        }

        @Override
        public void accept(T t, Throwable throwable) {
            try {
                if (this.delegate != null) {
                    this.delegate.accept(t, throwable);
                }
            }
            finally {
                if (throwable == null) {
                    NearCachedClientCacheProxy.this.cacheOrInvalidate(this.key, this.keyData, this.value, this.valueData);
                } else {
                    NearCachedClientCacheProxy.this.invalidateNearCache(this.key);
                }
            }
        }
    }

    private final class PutAsyncOneShotCallback
    implements BiConsumer<V, Throwable> {
        private final AtomicBoolean executed;
        private final Object key;
        private final Data keyData;
        private final V newValue;
        private final Data newValueData;
        private final BiConsumer<V, Throwable> statsCallback;

        private PutAsyncOneShotCallback(Object key, Data keyData, V newValue, Data newValueData, BiConsumer<V, Throwable> callback) {
            this.key = key;
            this.keyData = keyData;
            this.newValue = newValue;
            this.newValueData = newValueData;
            this.statsCallback = callback;
            this.executed = new AtomicBoolean();
        }

        @Override
        public void accept(V v, Throwable throwable) {
            if (!this.executed.compareAndSet(false, true)) {
                return;
            }
            try {
                if (this.statsCallback != null) {
                    this.statsCallback.accept(v, throwable);
                }
            }
            finally {
                if (throwable == null) {
                    NearCachedClientCacheProxy.this.cacheOrInvalidate(this.key, this.keyData, this.newValue, this.newValueData);
                } else {
                    NearCachedClientCacheProxy.this.invalidateNearCache(this.key);
                }
            }
        }
    }

    private final class GetAsyncCallback
    implements BiConsumer<V, Throwable> {
        private final Object key;
        private final long reservationId;
        private final BiConsumer<V, Throwable> callback;

        GetAsyncCallback(Object key, long reservationId, BiConsumer<V, Throwable> callback) {
            this.key = key;
            this.reservationId = reservationId;
            this.callback = callback;
        }

        @Override
        public void accept(V valueData, Throwable throwable) {
            try {
                if (this.callback != null) {
                    this.callback.accept(valueData, throwable);
                }
            }
            finally {
                if (throwable == null) {
                    NearCachedClientCacheProxy.this.tryPublishReserved(this.key, valueData, this.reservationId, false);
                } else {
                    NearCachedClientCacheProxy.this.invalidateNearCache(this.key);
                }
            }
        }
    }
}

