/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ClientNetworkConfig {
    private static final int CONNECTION_TIMEOUT = 5000;
    private final List<String> addressList;
    private boolean smartRouting = true;
    private boolean redoOperation;
    private int connectionTimeout = 5000;
    private SocketInterceptorConfig socketInterceptorConfig = new SocketInterceptorConfig();
    private SocketOptions socketOptions = new SocketOptions();
    private SSLConfig sslConfig;
    private AwsConfig awsConfig = new AwsConfig();
    private GcpConfig gcpConfig = new GcpConfig();
    private AzureConfig azureConfig = new AzureConfig();
    private KubernetesConfig kubernetesConfig = new KubernetesConfig();
    private EurekaConfig eurekaConfig = new EurekaConfig();
    private ClientCloudConfig cloudConfig = new ClientCloudConfig();
    private DiscoveryConfig discoveryConfig = new DiscoveryConfig();
    private Collection<String> outboundPortDefinitions;
    private Collection<Integer> outboundPorts;
    private ClientIcmpPingConfig clientIcmpPingConfig = new ClientIcmpPingConfig();

    public ClientNetworkConfig() {
        this.addressList = new ArrayList<String>();
    }

    public ClientNetworkConfig(ClientNetworkConfig networkConfig) {
        this.addressList = new ArrayList<String>(networkConfig.addressList);
        this.smartRouting = networkConfig.smartRouting;
        this.redoOperation = networkConfig.redoOperation;
        this.connectionTimeout = networkConfig.connectionTimeout;
        this.socketInterceptorConfig = new SocketInterceptorConfig(networkConfig.socketInterceptorConfig);
        this.socketOptions = new SocketOptions(networkConfig.socketOptions);
        this.sslConfig = networkConfig.sslConfig == null ? null : new SSLConfig(networkConfig.sslConfig);
        this.awsConfig = new AwsConfig(networkConfig.awsConfig);
        this.gcpConfig = new GcpConfig(networkConfig.gcpConfig);
        this.azureConfig = new AzureConfig(networkConfig.azureConfig);
        this.kubernetesConfig = new KubernetesConfig(networkConfig.kubernetesConfig);
        this.eurekaConfig = new EurekaConfig(networkConfig.eurekaConfig);
        this.cloudConfig = new ClientCloudConfig(networkConfig.cloudConfig);
        this.discoveryConfig = new DiscoveryConfig(networkConfig.discoveryConfig);
        this.outboundPortDefinitions = networkConfig.outboundPortDefinitions == null ? null : new HashSet<String>(networkConfig.outboundPortDefinitions);
        this.outboundPorts = networkConfig.outboundPorts == null ? null : new HashSet<Integer>(networkConfig.outboundPorts);
        this.clientIcmpPingConfig = new ClientIcmpPingConfig(networkConfig.clientIcmpPingConfig);
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public ClientNetworkConfig setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = Preconditions.isNotNull(discoveryConfig, "discoveryConfig");
        return this;
    }

    public boolean isSmartRouting() {
        return this.smartRouting;
    }

    public ClientNetworkConfig setSmartRouting(boolean smartRouting) {
        this.smartRouting = smartRouting;
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public ClientNetworkConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = Preconditions.isNotNull(socketInterceptorConfig, "socketInterceptorConfig");
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientNetworkConfig setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("connectionTimeout cannot be negative");
        }
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ClientNetworkConfig addAddress(String ... addresses) {
        Preconditions.isNotNull(addresses, "addresses");
        for (String address : addresses) {
            Preconditions.isNotNull(address, "address");
            Preconditions.checkHasText(address.trim(), "member must contain text");
        }
        Collections.addAll(this.addressList, addresses);
        return this;
    }

    public ClientNetworkConfig setAddresses(List<String> addresses) {
        Preconditions.isNotNull(addresses, "addresses");
        this.addressList.clear();
        this.addressList.addAll(addresses);
        return this;
    }

    public List<String> getAddresses() {
        return this.addressList;
    }

    public boolean isRedoOperation() {
        return this.redoOperation;
    }

    public ClientNetworkConfig setRedoOperation(boolean redoOperation) {
        this.redoOperation = redoOperation;
        return this;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ClientNetworkConfig setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
        return this;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public ClientNetworkConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public ClientNetworkConfig setAwsConfig(AwsConfig clientAwsConfig) {
        Preconditions.isNotNull(clientAwsConfig, "clientAwsConfig");
        this.awsConfig = clientAwsConfig;
        return this;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public ClientNetworkConfig setGcpConfig(GcpConfig gcpConfig) {
        Preconditions.isNotNull(gcpConfig, "gcpConfig");
        this.gcpConfig = gcpConfig;
        return this;
    }

    public GcpConfig getGcpConfig() {
        return this.gcpConfig;
    }

    public ClientNetworkConfig setAzureConfig(AzureConfig azureConfig) {
        Preconditions.isNotNull(azureConfig, "azureConfig");
        this.azureConfig = azureConfig;
        return this;
    }

    public AzureConfig getAzureConfig() {
        return this.azureConfig;
    }

    public ClientNetworkConfig setKubernetesConfig(KubernetesConfig kubernetesConfig) {
        Preconditions.isNotNull(kubernetesConfig, "kubernetesConfig");
        this.kubernetesConfig = kubernetesConfig;
        return this;
    }

    public KubernetesConfig getKubernetesConfig() {
        return this.kubernetesConfig;
    }

    public ClientNetworkConfig setEurekaConfig(EurekaConfig eurekaConfig) {
        Preconditions.isNotNull(eurekaConfig, "eurekaConfig");
        this.eurekaConfig = eurekaConfig;
        return this;
    }

    public EurekaConfig getEurekaConfig() {
        return this.eurekaConfig;
    }

    public ClientCloudConfig getCloudConfig() {
        return this.cloudConfig;
    }

    public ClientNetworkConfig setCloudConfig(ClientCloudConfig cloudConfig) {
        Preconditions.isNotNull(cloudConfig, "cloudConfig");
        this.cloudConfig = cloudConfig;
        return this;
    }

    public Collection<String> getOutboundPortDefinitions() {
        return this.outboundPortDefinitions;
    }

    public Collection<Integer> getOutboundPorts() {
        return this.outboundPorts;
    }

    public ClientNetworkConfig setOutboundPortDefinitions(Collection<String> outboundPortDefinitions) {
        this.outboundPortDefinitions = outboundPortDefinitions;
        return this;
    }

    public ClientNetworkConfig setOutboundPorts(Collection<Integer> outboundPorts) {
        this.outboundPorts = outboundPorts;
        return this;
    }

    public ClientNetworkConfig addOutboundPort(int port) {
        if (this.outboundPorts == null) {
            this.outboundPorts = new HashSet<Integer>();
        }
        this.outboundPorts.add(port);
        return this;
    }

    public ClientNetworkConfig addOutboundPortDefinition(String portDef) {
        if (this.outboundPortDefinitions == null) {
            this.outboundPortDefinitions = new HashSet<String>();
        }
        this.outboundPortDefinitions.add(portDef);
        return this;
    }

    public ClientIcmpPingConfig getClientIcmpPingConfig() {
        return this.clientIcmpPingConfig;
    }

    public ClientNetworkConfig setClientIcmpPingConfig(ClientIcmpPingConfig clientIcmpPingConfig) {
        this.clientIcmpPingConfig = clientIcmpPingConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientNetworkConfig that = (ClientNetworkConfig)o;
        if (this.smartRouting != that.smartRouting) {
            return false;
        }
        if (this.redoOperation != that.redoOperation) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (!this.addressList.equals(that.addressList)) {
            return false;
        }
        if (!this.socketInterceptorConfig.equals(that.socketInterceptorConfig)) {
            return false;
        }
        if (!this.socketOptions.equals(that.socketOptions)) {
            return false;
        }
        if (this.sslConfig != null ? !this.sslConfig.equals(that.sslConfig) : that.sslConfig != null) {
            return false;
        }
        if (!this.awsConfig.equals(that.awsConfig)) {
            return false;
        }
        if (!this.gcpConfig.equals(that.gcpConfig)) {
            return false;
        }
        if (!this.azureConfig.equals(that.azureConfig)) {
            return false;
        }
        if (!this.kubernetesConfig.equals(that.kubernetesConfig)) {
            return false;
        }
        if (!this.eurekaConfig.equals(that.eurekaConfig)) {
            return false;
        }
        if (!this.cloudConfig.equals(that.cloudConfig)) {
            return false;
        }
        if (!this.discoveryConfig.equals(that.discoveryConfig)) {
            return false;
        }
        if (this.outboundPortDefinitions != null ? !this.outboundPortDefinitions.equals(that.outboundPortDefinitions) : that.outboundPortDefinitions != null) {
            return false;
        }
        if (this.outboundPorts != null ? !this.outboundPorts.equals(that.outboundPorts) : that.outboundPorts != null) {
            return false;
        }
        return this.clientIcmpPingConfig.equals(that.clientIcmpPingConfig);
    }

    public int hashCode() {
        int result = this.addressList.hashCode();
        result = 31 * result + (this.smartRouting ? 1 : 0);
        result = 31 * result + (this.redoOperation ? 1 : 0);
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + this.socketInterceptorConfig.hashCode();
        result = 31 * result + this.socketOptions.hashCode();
        result = 31 * result + (this.sslConfig != null ? this.sslConfig.hashCode() : 0);
        result = 31 * result + this.awsConfig.hashCode();
        result = 31 * result + this.gcpConfig.hashCode();
        result = 31 * result + this.azureConfig.hashCode();
        result = 31 * result + this.kubernetesConfig.hashCode();
        result = 31 * result + this.eurekaConfig.hashCode();
        result = 31 * result + this.cloudConfig.hashCode();
        result = 31 * result + this.discoveryConfig.hashCode();
        result = 31 * result + (this.outboundPortDefinitions != null ? this.outboundPortDefinitions.hashCode() : 0);
        result = 31 * result + (this.outboundPorts != null ? this.outboundPorts.hashCode() : 0);
        result = 31 * result + this.clientIcmpPingConfig.hashCode();
        return result;
    }

    public String toString() {
        return "ClientNetworkConfig{addressList=" + this.addressList + ", smartRouting=" + this.smartRouting + ", redoOperation=" + this.redoOperation + ", connectionTimeout=" + this.connectionTimeout + ", socketInterceptorConfig=" + this.socketInterceptorConfig + ", socketOptions=" + this.socketOptions + ", sslConfig=" + this.sslConfig + ", awsConfig=" + this.awsConfig + ", gcpConfig=" + this.gcpConfig + ", azureConfig=" + this.azureConfig + ", kubernetesConfig=" + this.kubernetesConfig + ", eurekaConfig=" + this.eurekaConfig + ", cloudConfig=" + this.cloudConfig + ", discoveryConfig=" + this.discoveryConfig + ", outboundPortDefinitions=" + this.outboundPortDefinitions + ", outboundPorts=" + this.outboundPorts + ", clientIcmpPingConfig=" + this.clientIcmpPingConfig + '}';
    }
}

