/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

public class ConnectionRetryConfig {
    private static final int INITIAL_BACKOFF_MILLIS = 1000;
    private static final int MAX_BACKOFF_MILLIS = 30000;
    private static final double JITTER = 0.2;
    private int initialBackoffMillis = 1000;
    private int maxBackoffMillis = 30000;
    private double multiplier = 2.0;
    private boolean failOnMaxBackoff = true;
    private double jitter = 0.2;
    private boolean enabled;

    public ConnectionRetryConfig() {
    }

    public ConnectionRetryConfig(ConnectionRetryConfig connectionRetryConfig) {
        this.initialBackoffMillis = connectionRetryConfig.initialBackoffMillis;
        this.maxBackoffMillis = connectionRetryConfig.maxBackoffMillis;
        this.multiplier = connectionRetryConfig.multiplier;
        this.failOnMaxBackoff = connectionRetryConfig.failOnMaxBackoff;
        this.jitter = connectionRetryConfig.jitter;
        this.enabled = connectionRetryConfig.enabled;
    }

    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public ConnectionRetryConfig setInitialBackoffMillis(int initialBackoffMillis) {
        this.initialBackoffMillis = initialBackoffMillis;
        return this;
    }

    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    public ConnectionRetryConfig setMaxBackoffMillis(int maxBackoffMillis) {
        this.maxBackoffMillis = maxBackoffMillis;
        return this;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public ConnectionRetryConfig setMultiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public boolean isFailOnMaxBackoff() {
        return this.failOnMaxBackoff;
    }

    public ConnectionRetryConfig setFailOnMaxBackoff(boolean failOnMaxBackoff) {
        this.failOnMaxBackoff = failOnMaxBackoff;
        return this;
    }

    public double getJitter() {
        return this.jitter;
    }

    public ConnectionRetryConfig setJitter(double jitter) {
        this.jitter = jitter;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionRetryConfig that = (ConnectionRetryConfig)o;
        if (this.initialBackoffMillis != that.initialBackoffMillis) {
            return false;
        }
        if (this.maxBackoffMillis != that.maxBackoffMillis) {
            return false;
        }
        if (Double.compare(that.multiplier, this.multiplier) != 0) {
            return false;
        }
        if (this.failOnMaxBackoff != that.failOnMaxBackoff) {
            return false;
        }
        if (Double.compare(that.jitter, this.jitter) != 0) {
            return false;
        }
        return this.enabled == that.enabled;
    }

    public int hashCode() {
        int result = this.initialBackoffMillis;
        result = 31 * result + this.maxBackoffMillis;
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.failOnMaxBackoff ? 1 : 0);
        temp = Double.doubleToLongBits(this.jitter);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ConnectionRetryConfig{enabled=" + this.enabled + ", initialBackoffMillis=" + this.initialBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", multiplier=" + this.multiplier + ", failOnMaxBackoff=" + this.failOnMaxBackoff + ", jitter=" + this.jitter + '}';
    }
}

