/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.impl.spi.ClientProxyFactory;

public class ProxyFactoryConfig {
    private String service;
    private String className;
    private ClientProxyFactory factoryImpl;

    public ProxyFactoryConfig() {
    }

    public ProxyFactoryConfig(String className, String service) {
        this.className = className;
        this.service = service;
    }

    public ProxyFactoryConfig(String service, ClientProxyFactory factoryImpl) {
        this.service = service;
        this.factoryImpl = factoryImpl;
    }

    public ProxyFactoryConfig(ProxyFactoryConfig factoryConfig) {
        this.service = factoryConfig.service;
        this.className = factoryConfig.className;
        this.factoryImpl = factoryConfig.factoryImpl;
    }

    public String getClassName() {
        return this.className;
    }

    public ProxyFactoryConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getService() {
        return this.service;
    }

    public ProxyFactoryConfig setService(String service) {
        this.service = service;
        return this;
    }

    public ClientProxyFactory getFactoryImpl() {
        return this.factoryImpl;
    }

    public ProxyFactoryConfig setFactoryImpl(ClientProxyFactory factoryImpl) {
        this.factoryImpl = factoryImpl;
        return this;
    }

    private String internalClassName() {
        if (this.factoryImpl != null) {
            return this.factoryImpl.getClass().getName();
        }
        return this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyFactoryConfig that = (ProxyFactoryConfig)o;
        String thisClassName = this.internalClassName();
        String thatClassName = that.internalClassName();
        if (thisClassName != null ? !thisClassName.equals(thatClassName) : thatClassName != null) {
            return false;
        }
        return !(this.service != null ? !this.service.equals(that.service) : that.service != null);
    }

    public int hashCode() {
        int result = this.service != null ? this.service.hashCode() : 0;
        String internalClassName = this.internalClassName();
        result = 31 * result + (internalClassName != null ? internalClassName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ProxyFactoryConfig{service='" + this.service + '\'' + ", className='" + this.className + '\'' + ", factoryImpl=" + this.factoryImpl + '}';
    }
}

