/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.AbstractQueryCacheConfigBuilderHelper;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.query.impl.IndexUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class QueryCacheXmlConfigBuilderHelper
extends AbstractQueryCacheConfigBuilderHelper {
    QueryCacheXmlConfigBuilderHelper(boolean domLevel3) {
        super(domLevel3);
    }

    @Override
    public void handleQueryCache(ClientConfig clientConfig, Node node) {
        for (Node queryCacheNode : DomConfigHelper.childElements(node)) {
            if (!"query-cache".equals(DomConfigHelper.cleanNodeName(queryCacheNode))) continue;
            this.handleQueryCacheNode(clientConfig, queryCacheNode);
        }
    }

    @Override
    protected String getCacheName(Node queryCacheNode) {
        NamedNodeMap attrs = queryCacheNode.getAttributes();
        return this.getTextContent(attrs.getNamedItem("name"));
    }

    @Override
    protected String getCacheMapName(NamedNodeMap attrs) {
        return this.getTextContent(attrs.getNamedItem("mapName"));
    }

    @Override
    protected void handleEntryListeners(QueryCacheConfig queryCacheConfig, Node childNode) {
        for (Node listenerNode : DomConfigHelper.childElements(childNode)) {
            if (!"entry-listener".equals(DomConfigHelper.cleanNodeName(listenerNode))) continue;
            this.handleEntryListenerNode(queryCacheConfig, listenerNode);
        }
    }

    @Override
    protected void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        NamedNodeMap predicateAttributes = childNode.getAttributes();
        String predicateType = this.getTextContent(predicateAttributes.getNamedItem("type"));
        String textContent = this.getTextContent(childNode);
        PredicateConfig predicateConfig = new PredicateConfig();
        if ("class-name".equals(predicateType)) {
            predicateConfig.setClassName(textContent);
        } else if ("sql".equals(predicateType)) {
            predicateConfig.setSql(textContent);
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    @Override
    protected void queryCacheIndexesHandle(Node n, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : DomConfigHelper.childElements(n)) {
            if (!"index".equals(DomConfigHelper.cleanNodeName(indexNode))) continue;
            IndexConfig indexConfig = IndexUtils.getIndexConfigFromXml(indexNode, this.domLevel3);
            queryCacheConfig.addIndexConfig(indexConfig);
        }
    }
}

