/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigSections;
import com.hazelcast.client.config.YamlClientConfigLocator;
import com.hazelcast.client.config.YamlClientDomConfigProcessor;
import com.hazelcast.config.AbstractYamlConfigBuilder;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.yaml.W3cDomUtil;
import com.hazelcast.internal.config.yaml.YamlDomChecker;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.w3c.dom.Node;

public class YamlClientConfigBuilder
extends AbstractYamlConfigBuilder {
    private final InputStream in;

    public YamlClientConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig(resource);
        Preconditions.checkTrue(url != null, "Could not load " + resource);
        this.in = url.openStream();
    }

    public YamlClientConfigBuilder(File file) throws IOException {
        Preconditions.checkNotNull(file, "File is null!");
        this.in = new FileInputStream(file);
    }

    public YamlClientConfigBuilder(URL url) throws IOException {
        Preconditions.checkNotNull(url, "URL is null!");
        this.in = url.openStream();
    }

    public YamlClientConfigBuilder(InputStream in) {
        this.in = in;
    }

    public YamlClientConfigBuilder() {
        this((YamlClientConfigLocator)null);
    }

    public YamlClientConfigBuilder(YamlClientConfigLocator locator) {
        if (locator == null) {
            locator = new YamlClientConfigLocator();
            locator.locateEverywhere();
        }
        this.in = locator.getIn();
    }

    public ClientConfig build() {
        return this.build(Thread.currentThread().getContextClassLoader());
    }

    public ClientConfig build(ClassLoader classLoader) {
        ClientConfig clientConfig = new ClientConfig();
        this.build(clientConfig, classLoader);
        return clientConfig;
    }

    public YamlClientConfigBuilder setProperties(Properties properties) {
        this.setPropertiesInternal(properties);
        return this;
    }

    void build(ClientConfig clientConfig, ClassLoader classLoader) {
        clientConfig.setClassLoader(classLoader);
        try {
            this.parseAndBuildConfig(clientConfig);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            IOUtil.closeResource(this.in);
        }
    }

    private void parseAndBuildConfig(ClientConfig config) throws Exception {
        YamlMapping yamlRootNode;
        try {
            yamlRootNode = (YamlMapping)YamlLoader.load(this.in);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Invalid YAML configuration", ex);
        }
        YamlMapping clientRoot = yamlRootNode.childAsMapping(ClientConfigSections.HAZELCAST_CLIENT.name);
        if (clientRoot == null) {
            clientRoot = yamlRootNode;
        }
        YamlDomChecker.check(clientRoot);
        Node w3cRootNode = W3cDomUtil.asW3cNode(clientRoot);
        this.replaceVariables(w3cRootNode);
        this.importDocuments(clientRoot);
        new YamlClientDomConfigProcessor(true, config).buildConfig(w3cRootNode);
    }

    @Override
    protected String getConfigRoot() {
        return ClientConfigSections.HAZELCAST_CLIENT.name;
    }
}

