/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal;

import com.hazelcast.client.cp.internal.datastructures.proxy.ClientRaftProxyFactory;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;

public class CPSubsystemImpl
implements CPSubsystem {
    private final ClientRaftProxyFactory proxyFactory;

    public CPSubsystemImpl(HazelcastClientInstanceImpl client) {
        this.proxyFactory = new ClientRaftProxyFactory(client);
    }

    public void init(ClientContext context) {
        this.proxyFactory.init(context);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        return (IAtomicLong)this.proxyFactory.createProxy("hz:raft:atomicLongService", name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return (IAtomicReference)this.proxyFactory.createProxy("hz:raft:atomicRefService", name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.proxyFactory.createProxy("hz:raft:countDownLatchService", name);
    }

    @Override
    public FencedLock getLock(String name) {
        return (FencedLock)this.proxyFactory.createProxy("hz:raft:lockService", name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.proxyFactory.createProxy("hz:raft:semaphoreService", name);
    }

    @Override
    public CPMember getLocalCPMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPSubsystemManagementService getCPSubsystemManagementService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPSessionManagementService getCPSessionManagementService() {
        throw new UnsupportedOperationException();
    }
}

