/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.proxy;

import com.hazelcast.client.cp.internal.datastructures.atomiclong.AtomicLongProxy;
import com.hazelcast.client.cp.internal.datastructures.atomicref.AtomicRefProxy;
import com.hazelcast.client.cp.internal.datastructures.countdownlatch.CountDownLatchProxy;
import com.hazelcast.client.cp.internal.datastructures.lock.FencedLockProxy;
import com.hazelcast.client.cp.internal.datastructures.semaphore.SessionAwareSemaphoreProxy;
import com.hazelcast.client.cp.internal.datastructures.semaphore.SessionlessSemaphoreProxy;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupCreateCPGroupCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreGetSemaphoreTypeCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.lock.FencedLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientRaftProxyFactory {
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<String, FencedLockProxy> lockProxies = new ConcurrentHashMap<String, FencedLockProxy>();
    private ClientContext context;

    public ClientRaftProxyFactory(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public void init(ClientContext context) {
        this.context = context;
    }

    public <T extends DistributedObject> T createProxy(String serviceName, String proxyName) {
        proxyName = RaftService.withoutDefaultGroupName(proxyName);
        String objectName = RaftService.getObjectNameForProxy(proxyName);
        RaftGroupId groupId = this.getGroupId(proxyName, objectName);
        if (serviceName.equals("hz:raft:atomicLongService")) {
            return (T)new AtomicLongProxy(this.context, groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:atomicRefService")) {
            return (T)new AtomicRefProxy(this.context, groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:countDownLatchService")) {
            return (T)new CountDownLatchProxy(this.context, groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:lockService")) {
            return (T)this.createFencedLock(groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:semaphoreService")) {
            return (T)this.createSemaphore(groupId, proxyName, objectName);
        }
        throw new IllegalArgumentException();
    }

    private FencedLock createFencedLock(RaftGroupId groupId, String proxyName, String objectName) {
        while (true) {
            FencedLockProxy existing;
            FencedLockProxy proxy;
            if ((proxy = (FencedLockProxy)this.lockProxies.get(proxyName)) != null) {
                if (!proxy.getGroupId().equals(groupId)) {
                    this.lockProxies.remove(proxyName, proxy);
                } else {
                    return proxy;
                }
            }
            if ((existing = this.lockProxies.putIfAbsent(proxyName, proxy = new FencedLockProxy(this.context, groupId, proxyName, objectName))) == null) {
                return proxy;
            }
            if (existing.getGroupId().equals(groupId)) {
                return existing;
            }
            groupId = this.getGroupId(proxyName, objectName);
        }
    }

    private ISemaphore createSemaphore(RaftGroupId groupId, String proxyName, String objectName) {
        ClientMessage request = SemaphoreGetSemaphoreTypeCodec.encodeRequest(proxyName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, objectName).invoke().join();
        boolean jdkCompatible = SemaphoreGetSemaphoreTypeCodec.decodeResponse((ClientMessage)response).response;
        return jdkCompatible ? new SessionlessSemaphoreProxy(this.context, groupId, proxyName, objectName) : new SessionAwareSemaphoreProxy(this.context, groupId, proxyName, objectName);
    }

    private RaftGroupId getGroupId(String proxyName, String objectName) {
        ClientMessage request = CPGroupCreateCPGroupCodec.encodeRequest(proxyName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, objectName).invoke().joinInternal();
        return CPGroupCreateCPGroupCodec.decodeResponse((ClientMessage)response).groupId;
    }
}

