/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.DelegatingCompletableFuture;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClientDelegatingFuture<V>
extends DelegatingCompletableFuture<V> {
    private static final AtomicReferenceFieldUpdater<ClientDelegatingFuture, Object> DECODED_RESPONSE = AtomicReferenceFieldUpdater.newUpdater(ClientDelegatingFuture.class, Object.class, "decodedResponse");
    private static final Object VOID = "VOID";
    final boolean deserializeResponse;
    final ClientInvocationFuture future;
    private final SerializationService serializationService;
    private final ClientMessageDecoder clientMessageDecoder;
    private final V defaultValue;
    private final Executor userExecutor;
    private volatile Object decodedResponse = VOID;

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, V defaultValue, boolean deserializeResponse) {
        super(serializationService, clientInvocationFuture, defaultValue);
        this.future = clientInvocationFuture;
        this.serializationService = serializationService;
        this.clientMessageDecoder = clientMessageDecoder;
        this.defaultValue = defaultValue;
        this.userExecutor = clientInvocationFuture.getInvocation().getUserExecutor();
        this.deserializeResponse = deserializeResponse;
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, V defaultValue) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, defaultValue, true);
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, null, true);
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, boolean deserializeResponse) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, null, deserializeResponse);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ClientMessage response = (ClientMessage)this.future.get(timeout, unit);
        return this.resolveResponse(response, this.deserializeResponse);
    }

    @Override
    public V join() {
        ClientMessage response = (ClientMessage)this.future.join();
        return this.resolveResponse(response, this.deserializeResponse);
    }

    @Override
    public V joinInternal() {
        ClientMessage response = (ClientMessage)this.future.joinInternal();
        return this.resolveResponse(response, this.deserializeResponse);
    }

    protected V resolveResponse(ClientMessage clientMessage, boolean deserialize) {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        Object decodedResponse = this.decodeResponse(clientMessage);
        if (deserialize) {
            return (V)this.serializationService.toObject(decodedResponse);
        }
        return (V)decodedResponse;
    }

    private Object resolveAny(Object o, boolean deserialize) {
        if (o instanceof ClientMessage) {
            return this.resolveResponse((ClientMessage)o, deserialize);
        }
        if (deserialize) {
            return this.serializationService.toObject(o);
        }
        return o;
    }

    private Object decodeResponse(ClientMessage clientMessage) {
        if (this.decodedResponse != VOID) {
            return this.decodedResponse;
        }
        Object newDecodedResponse = this.clientMessageDecoder.decodeClientMessage(clientMessage);
        DECODED_RESPONSE.compareAndSet(this, VOID, newDecodedResponse);
        return newDecodedResponse;
    }

    protected ClientInvocationFuture getFuture() {
        return this.future;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super V, ? extends U> fn) {
        return this.future.thenApply(new DeserializingFunction<U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return this.future.thenApplyAsync(new DeserializingFunction<U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        return this.future.thenApplyAsync(new DeserializingFunction<U>(fn), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super V> action) {
        return this.future.thenAccept((Consumer)new DeserializingConsumer(action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action) {
        return this.future.thenAcceptAsync((Consumer)new DeserializingConsumer(action), this.userExecutor);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        return this.future.thenAcceptAsync((Consumer)new DeserializingConsumer(action), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.future.thenRun(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.future.thenRunAsync(action, this.userExecutor);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.future.thenRunAsync(action, executor);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombine((CompletionStage)other, new DeserializingBiFunction<U, V1>(fn));
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<U, V1>(fn), this.userExecutor);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<U, V1>(fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBoth((CompletionStage)other, new DeserializingBiConsumer<U>(action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<U>(action), this.userExecutor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<U>(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return ClientDelegatingFuture.applyToEitherAsync(this.future, other, new DeserializingFunction<U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return ClientDelegatingFuture.applyToEither(this.future, other, new DeserializingFunction<U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn, Executor executor) {
        return ClientDelegatingFuture.applyToEitherAsync(this.future, other, new DeserializingFunction<U>(fn), executor);
    }

    private static CompletableFuture applyToEither(CompletableFuture stage, CompletionStage other, Function fn) {
        return stage.applyToEither(other, fn);
    }

    private static CompletableFuture applyToEitherAsync(CompletableFuture stage, CompletionStage other, Function fn) {
        return stage.applyToEitherAsync(other, fn);
    }

    private static CompletableFuture applyToEitherAsync(CompletableFuture stage, CompletionStage other, Function fn, Executor executor) {
        return stage.applyToEitherAsync(other, fn, executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return ClientDelegatingFuture.acceptEither(this.future, other, new DeserializingConsumer(action));
    }

    private static CompletableFuture<Void> acceptEither(CompletionStage stage, CompletionStage other, Consumer action) {
        return (CompletableFuture)stage.acceptEither(other, action);
    }

    private static CompletableFuture<Void> acceptEitherAsync(CompletionStage stage, CompletionStage other, Consumer action) {
        return (CompletableFuture)stage.acceptEitherAsync(other, action);
    }

    private static CompletableFuture<Void> acceptEitherAsync(CompletionStage stage, CompletionStage other, Consumer action, Executor executor) {
        return (CompletableFuture)stage.acceptEitherAsync(other, action, executor);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return ClientDelegatingFuture.acceptEitherAsync(this.future, other, new DeserializingConsumer(action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action, Executor executor) {
        return ClientDelegatingFuture.acceptEitherAsync(this.future, other, new DeserializingConsumer(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action, this.userExecutor);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenCompose(new DeserializingFunction<CompletionStage<U>>(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenComposeAsync(new DeserializingFunction<CompletionStage<U>>(fn), this.userExecutor);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.future.thenComposeAsync(new DeserializingFunction<CompletionStage<U>>(fn), executor);
    }

    @Override
    public CompletableFuture<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        InternalCompletableFuture completableFuture = InternalCompletableFuture.withExecutor(this.userExecutor);
        this.future.whenComplete(new DeserializingBiConsumer<Throwable>(action, completableFuture));
        return completableFuture;
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        InternalCompletableFuture completableFuture = InternalCompletableFuture.withExecutor(this.userExecutor);
        this.future.whenCompleteAsync(new DeserializingBiConsumer<Throwable>(action, completableFuture), this.userExecutor);
        return completableFuture;
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        InternalCompletableFuture completableFuture = InternalCompletableFuture.withExecutor(this.userExecutor);
        this.future.whenCompleteAsync(new DeserializingBiConsumer<Throwable>(action, completableFuture), executor);
        return completableFuture;
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handle(new DeserializingBiFunction<Throwable, U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handleAsync(new DeserializingBiFunction<Throwable, U>(fn), this.userExecutor);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        return this.future.handleAsync(new DeserializingBiFunction<Throwable, U>(fn), executor);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<V> exceptionally(Function<Throwable, ? extends V> fn) {
        InternalCompletableFuture completableFuture = InternalCompletableFuture.withExecutor(this.userExecutor);
        this.future.exceptionally((T throwable) -> {
            try {
                Object value = fn.apply((Throwable)throwable);
                completableFuture.complete(value);
            }
            catch (Throwable t) {
                completableFuture.completeExceptionally(t);
            }
            return null;
        });
        return completableFuture;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.future.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void obtrudeException(Throwable ex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfDependents() {
        return this.future.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.future.toString();
    }

    class DeserializingBiConsumer<U>
    implements BiConsumer<ClientMessage, U> {
        private final BiConsumer<? super V, U> delegate;
        private final CompletableFuture<V> future;

        DeserializingBiConsumer(BiConsumer<? super V, U> delegate) {
            this.delegate = delegate;
            this.future = null;
        }

        DeserializingBiConsumer(BiConsumer<? super V, U> delegate, CompletableFuture<V> future) {
            this.delegate = delegate;
            this.future = future;
        }

        @Override
        public void accept(ClientMessage t, U u) {
            block3: {
                Object resolved = t == null ? null : (Object)ClientDelegatingFuture.this.resolveResponse(t, ClientDelegatingFuture.this.deserializeResponse);
                try {
                    this.delegate.accept(resolved, ClientDelegatingFuture.this.resolveAny(u, ClientDelegatingFuture.this.deserializeResponse));
                    if (this.future != null) {
                        this.future.complete(resolved);
                    }
                }
                catch (Throwable throwable) {
                    if (this.future == null) break block3;
                    this.future.completeExceptionally(throwable);
                }
            }
        }
    }

    class DeserializingBiFunction<U, R>
    implements BiFunction<ClientMessage, U, R> {
        private final BiFunction<? super V, U, ? extends R> delegate;

        DeserializingBiFunction(BiFunction<? super V, U, ? extends R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R apply(ClientMessage t, U u) {
            return this.delegate.apply(ClientDelegatingFuture.this.resolveResponse(t, ClientDelegatingFuture.this.deserializeResponse), ClientDelegatingFuture.this.resolveAny(u, ClientDelegatingFuture.this.deserializeResponse));
        }
    }

    class DeserializingConsumer
    implements Consumer<ClientMessage> {
        private final Consumer<? super V> delegate;

        DeserializingConsumer(Consumer<? super V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(ClientMessage e) {
            Object resolved = ClientDelegatingFuture.this.resolveResponse(e, ClientDelegatingFuture.this.deserializeResponse);
            this.delegate.accept(resolved);
        }

        public String toString() {
            return "DeserializingConsumer{delegate=" + this.delegate + '}';
        }
    }

    class DeserializingFunction<R>
    implements Function<ClientMessage, R> {
        private final Function<? super V, ? extends R> delegate;

        DeserializingFunction(Function<? super V, ? extends R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R apply(ClientMessage e) {
            return this.delegate.apply(ClientDelegatingFuture.this.resolveResponse(e, ClientDelegatingFuture.this.deserializeResponse));
        }
    }
}

