/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientType;
import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.tcp.TcpIpConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.xa.XATransactionContextImpl;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClientEndpointImpl
implements ClientEndpoint {
    private final ClientEngine clientEngine;
    private final ILogger logger;
    private final NodeEngineImpl nodeEngine;
    private final Connection connection;
    private final ConcurrentMap<UUID, TransactionContext> transactionContextMap = new ConcurrentHashMap<UUID, TransactionContext>();
    private final ConcurrentHashMap<UUID, Callable> removeListenerActions = new ConcurrentHashMap();
    private final SocketAddress socketAddress;
    private final long creationTime;
    private LoginContext loginContext;
    private UUID clientUuid;
    private Credentials credentials;
    private volatile boolean authenticated;
    private String clientVersion;
    private volatile String stats;
    private String clientName;
    private Set<String> labels;

    public ClientEndpointImpl(ClientEngine clientEngine, NodeEngineImpl nodeEngine, Connection connection) {
        this.clientEngine = clientEngine;
        this.logger = clientEngine.getLogger(this.getClass());
        this.nodeEngine = nodeEngine;
        this.connection = connection;
        if (connection instanceof TcpIpConnection) {
            TcpIpConnection tcpIpConnection = (TcpIpConnection)connection;
            this.socketAddress = tcpIpConnection.getRemoteSocketAddress();
        } else {
            this.socketAddress = null;
        }
        this.clientVersion = "Unknown";
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public UUID getUuid() {
        return this.clientUuid;
    }

    @Override
    public boolean isAlive() {
        return this.connection.isAlive();
    }

    @Override
    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    @Override
    public Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    @Override
    public void authenticated(UUID clientUuid, Credentials credentials, String clientVersion, long authCorrelationId, String clientName, Set<String> labels) {
        this.clientUuid = clientUuid;
        this.credentials = credentials;
        this.authenticated = true;
        this.setClientVersion(clientVersion);
        this.clientName = clientName;
        this.labels = labels;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void setClientVersion(String version) {
        this.clientVersion = version;
    }

    @Override
    public void setClientStatistics(String stats) {
        this.stats = stats;
    }

    @Override
    public String getClientStatistics() {
        return this.stats;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.socketAddress;
    }

    @Override
    public ClientType getClientType() {
        ClientType type;
        switch (this.connection.getType()) {
            case JAVA_CLIENT: {
                type = ClientType.JAVA;
                break;
            }
            case CSHARP_CLIENT: {
                type = ClientType.CSHARP;
                break;
            }
            case CPP_CLIENT: {
                type = ClientType.CPP;
                break;
            }
            case PYTHON_CLIENT: {
                type = ClientType.PYTHON;
                break;
            }
            case RUBY_CLIENT: {
                type = ClientType.RUBY;
                break;
            }
            case NODEJS_CLIENT: {
                type = ClientType.NODEJS;
                break;
            }
            case GO_CLIENT: {
                type = ClientType.GO;
                break;
            }
            case BINARY_CLIENT: {
                type = ClientType.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connection type: " + (Object)((Object)this.connection.getType()));
            }
        }
        return type;
    }

    @Override
    public String getName() {
        return this.clientName;
    }

    @Override
    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public TransactionContext getTransactionContext(UUID txnId) {
        TransactionContext transactionContext = (TransactionContext)this.transactionContextMap.get(txnId);
        if (transactionContext == null) {
            throw new TransactionException("No transaction context found for txnId:" + txnId);
        }
        return transactionContext;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContextMap.put(transactionContext.getTxnId(), transactionContext);
    }

    @Override
    public void removeTransactionContext(UUID txnId) {
        this.transactionContextMap.remove(txnId);
    }

    @Override
    public void addListenerDestroyAction(final String service, final String topic, final UUID id) {
        final EventService eventService = this.clientEngine.getEventService();
        this.addDestroyAction(id, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return eventService.deregisterListener(service, topic, id);
            }
        });
    }

    @Override
    public void addDestroyAction(UUID registrationId, Callable<Boolean> removeAction) {
        this.removeListenerActions.put(registrationId, removeAction);
    }

    @Override
    public boolean removeDestroyAction(UUID id) {
        return this.removeListenerActions.remove(id) != null;
    }

    @Override
    public void clearAllListeners() {
        for (Callable removeAction : this.removeListenerActions.values()) {
            try {
                removeAction.call();
            }
            catch (Exception e) {
                this.logger.warning("Exception during remove listener action", e);
            }
        }
        this.removeListenerActions.clear();
    }

    public void destroy() throws LoginException {
        this.clearAllListeners();
        this.nodeEngine.onClientDisconnected(this.getUuid());
        LoginContext lc = this.loginContext;
        if (lc != null) {
            lc.logout();
        }
        for (TransactionContext context : this.transactionContextMap.values()) {
            if (context instanceof XATransactionContextImpl) continue;
            try {
                context.rollbackTransaction();
            }
            catch (HazelcastInstanceNotActiveException e) {
                this.logger.finest(e);
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
        this.authenticated = false;
    }

    public String toString() {
        return "ClientEndpoint{connection=" + this.connection + ", clientUuid='" + this.clientUuid + ", authenticated=" + this.authenticated + ", clientVersion=" + this.clientVersion + ", creationTime=" + this.creationTime + ", latest statistics=" + this.stats + '}';
    }
}

