/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;

public class ClientInterceptingDelegatingFuture<V>
extends ClientDelegatingFuture<V> {
    private final BiConsumer<V, Throwable> interceptor;

    public ClientInterceptingDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, BiConsumer<V, Throwable> interceptor) {
        super(clientInvocationFuture, serializationService, clientMessageDecoder);
        this.interceptor = interceptor;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        Throwable originalThrowable = null;
        Throwable throwable = null;
        ClientMessage response = null;
        try {
            response = (ClientMessage)this.future.get();
        }
        catch (Throwable t) {
            originalThrowable = t;
            throwable = t instanceof ExecutionException ? t.getCause() : t;
        }
        return this.intercept(originalThrowable, throwable, response);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Throwable originalThrowable = null;
        Throwable throwable = null;
        ClientMessage response = null;
        try {
            response = (ClientMessage)this.future.get(timeout, unit);
        }
        catch (Throwable t) {
            originalThrowable = t;
            throwable = t instanceof ExecutionException ? t.getCause() : t;
        }
        return this.intercept(originalThrowable, throwable, response);
    }

    @Override
    public V join() {
        Throwable originalThrowable = null;
        Throwable throwable = null;
        ClientMessage response = null;
        try {
            response = (ClientMessage)this.future.join();
        }
        catch (Throwable t) {
            originalThrowable = t;
            throwable = t instanceof CompletionException ? t.getCause() : t;
        }
        return this.intercept(originalThrowable, throwable, response);
    }

    @Override
    public V joinInternal() {
        Throwable throwable = null;
        ClientMessage response = null;
        try {
            response = (ClientMessage)this.future.joinInternal();
        }
        catch (Throwable t) {
            throwable = t;
        }
        return this.intercept(throwable, throwable, response);
    }

    private V intercept(Throwable originalThrowable, Throwable throwable, ClientMessage response) {
        if (throwable != null) {
            this.interceptor.accept(null, throwable);
            throw ExceptionUtil.sneakyThrow(originalThrowable);
        }
        Object value = this.resolveResponse(response, this.deserializeResponse);
        this.interceptor.accept(value, null);
        return value;
    }
}

