/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionListenerCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientPartitionListenerService {
    private final Map<ClientEndpoint, Long> partitionListeningEndpoints = new ConcurrentHashMap<ClientEndpoint, Long>();
    private final NodeEngineImpl nodeEngine;
    private final boolean advancedNetworkConfigEnabled;

    ClientPartitionListenerService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.advancedNetworkConfigEnabled = nodeEngine.getConfig().getAdvancedNetworkConfig().isEnabled();
    }

    public void onPartitionStateChange() {
        for (Map.Entry<ClientEndpoint, Long> entry : this.partitionListeningEndpoints.entrySet()) {
            ClientMessage clientMessage = this.getPartitionsMessage();
            Long correlationId = entry.getValue();
            clientMessage.setCorrelationId(correlationId);
            ClientEndpoint clientEndpoint = entry.getKey();
            Connection connection = clientEndpoint.getConnection();
            connection.write(clientMessage);
        }
    }

    private ClientMessage getPartitionsMessage() {
        PartitionTableView partitionTableView = this.nodeEngine.getPartitionService().createPartitionTableView();
        Map<Address, List<Integer>> partitions = this.getPartitions(partitionTableView);
        int partitionStateVersion = partitionTableView.getVersion();
        return ClientAddPartitionListenerCodec.encodePartitionsEvent(partitions.entrySet(), partitionStateVersion);
    }

    public void registerPartitionListener(ClientEndpoint clientEndpoint, long correlationId) {
        this.partitionListeningEndpoints.put(clientEndpoint, correlationId);
        ClientMessage clientMessage = this.getPartitionsMessage();
        clientMessage.setCorrelationId(correlationId);
        clientEndpoint.getConnection().write(clientMessage);
    }

    public void deregisterPartitionListener(ClientEndpoint clientEndpoint) {
        this.partitionListeningEndpoints.remove(clientEndpoint);
    }

    public Map<Address, List<Integer>> getPartitions(PartitionTableView partitionTableView) {
        HashMap<Address, List<Integer>> partitionsMap = new HashMap<Address, List<Integer>>();
        int partitionCount = partitionTableView.getLength();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            PartitionReplica owner = partitionTableView.getReplica(partitionId, 0);
            if (owner == null) {
                partitionsMap.clear();
                return partitionsMap;
            }
            Address clientOwnerAddress = this.clientAddressOf(owner.address());
            if (clientOwnerAddress == null) {
                partitionsMap.clear();
                return partitionsMap;
            }
            LinkedList<Integer> indexes = (LinkedList<Integer>)partitionsMap.get(clientOwnerAddress);
            if (indexes == null) {
                indexes = new LinkedList<Integer>();
                partitionsMap.put(clientOwnerAddress, indexes);
            }
            indexes.add(partitionId);
        }
        return partitionsMap;
    }

    private Address clientAddressOf(Address memberAddress) {
        if (!this.advancedNetworkConfigEnabled) {
            return memberAddress;
        }
        MemberImpl member = this.nodeEngine.getClusterService().getMember(memberAddress);
        if (member != null) {
            return member.getAddressMap().get(EndpointQualifier.CLIENT);
        }
        return null;
    }
}

