/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Client;
import com.hazelcast.client.ClientListener;
import com.hazelcast.client.ClientService;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import java.util.Collection;
import java.util.UUID;

public final class ClientServiceProxy
implements ClientService {
    private final ClientEngine clientEngine;
    private final NodeEngine nodeEngine;

    public ClientServiceProxy(Node node) {
        this.clientEngine = node.clientEngine;
        this.nodeEngine = node.nodeEngine;
    }

    @Override
    public Collection<Client> getConnectedClients() {
        return this.clientEngine.getClients();
    }

    @Override
    public UUID addClientListener(ClientListener clientListener) {
        Preconditions.checkNotNull(clientListener, "clientListener should not be null");
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:core:clientEngine", "hz:core:clientEngine", clientListener);
        return registration.getId();
    }

    @Override
    public boolean removeClientListener(UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId should not be null");
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener("hz:core:clientEngine", "hz:core:clientEngine", registrationId);
    }
}

