/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.Client;
import com.hazelcast.client.ClientService;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.TerminatedLifecycleService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public class HazelcastClientProxy
implements HazelcastInstance,
SerializationServiceSupport {
    public volatile HazelcastClientInstanceImpl client;

    public HazelcastClientProxy(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public Config getConfig() {
        return this.getClient().getConfig();
    }

    @Override
    public String getName() {
        return this.getClient().getName();
    }

    @Override
    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return this.getClient().getRingbuffer(name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return this.getClient().getQueue(name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return this.getClient().getTopic(name);
    }

    @Override
    public <E> ITopic<E> getReliableTopic(String name) {
        return this.getClient().getReliableTopic(name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return this.getClient().getSet(name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return this.getClient().getList(name);
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return this.getClient().getMap(name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getClient().getMultiMap(name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return this.getClient().getReplicatedMap(name);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.getClient().getCacheManager();
    }

    @Override
    public Cluster getCluster() {
        return this.getClient().getCluster();
    }

    @Override
    public Client getLocalEndpoint() {
        return this.getClient().getLocalEndpoint();
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        return this.getClient().getExecutorService(name);
    }

    @Override
    public DurableExecutorService getDurableExecutorService(String name) {
        return this.getClient().getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.getClient().newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.getClient().newTransactionContext(options);
    }

    @Override
    public FlakeIdGenerator getFlakeIdGenerator(String name) {
        return this.getClient().getFlakeIdGenerator(name);
    }

    @Override
    public CardinalityEstimator getCardinalityEstimator(String name) {
        return this.getClient().getCardinalityEstimator(name);
    }

    @Override
    public PNCounter getPNCounter(String name) {
        return this.getClient().getPNCounter(name);
    }

    @Override
    public IScheduledExecutorService getScheduledExecutorService(String name) {
        return this.getClient().getScheduledExecutorService(name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getClient().getDistributedObjects();
    }

    @Override
    public UUID addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.getClient().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(UUID registrationId) {
        return this.getClient().removeDistributedObjectListener(registrationId);
    }

    @Override
    public PartitionService getPartitionService() {
        return this.getClient().getPartitionService();
    }

    @Override
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientService getClientService() {
        return this.getClient().getClientService();
    }

    @Override
    public LoggingService getLoggingService() {
        return this.getClient().getLoggingService();
    }

    @Override
    public LifecycleService getLifecycleService() {
        HazelcastClientInstanceImpl hz = this.client;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return this.getClient().getDistributedObject(serviceName, name);
    }

    @Override
    public CPSubsystem getCPSubsystem() {
        return this.getClient().getCPSubsystem();
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getClient().getUserContext();
    }

    public ClientConfig getClientConfig() {
        return this.getClient().getClientConfig();
    }

    @Override
    public HazelcastXAResource getXAResource() {
        return this.getClient().getXAResource();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.getClient().getSerializationService();
    }

    protected HazelcastClientInstanceImpl getClient() {
        HazelcastClientInstanceImpl c = this.client;
        if (c == null || !c.getLifecycleService().isRunning()) {
            throw new HazelcastClientNotActiveException("Client is not active.");
        }
        return c;
    }

    public String toString() {
        HazelcastClientInstanceImpl hazelcastInstance = this.client;
        if (hazelcastInstance != null) {
            return hazelcastInstance.toString();
        }
        return "HazelcastClientInstance {NOT ACTIVE}";
    }
}

