/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection;

import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;

public abstract class ClientConnectionStrategy {
    protected ClientContext clientContext;
    protected ILogger logger;
    protected ClientConnectionStrategyConfig clientConnectionStrategyConfig;

    public void init(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.clientConnectionStrategyConfig = clientContext.getClientConfig().getConnectionStrategyConfig();
        this.logger = clientContext.getLoggingService().getLogger(ClientConnectionStrategy.class);
    }

    public abstract void start();

    public abstract void beforeGetConnection(Address var1);

    public abstract void beforeOpenConnection(Address var1);

    public abstract void onClusterConnect();

    public abstract void onDisconnectFromCluster();

    public abstract void onConnect(ClientConnection var1);

    public abstract void onDisconnect(ClientConnection var1);

    public abstract void shutdown();
}

