/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.nio;

import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.internal.nio.Connection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;

class AuthenticationFuture {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private ClientConnection connection;
    private Throwable throwable;

    AuthenticationFuture() {
    }

    void onSuccess(ClientConnection connection) {
        this.connection = connection;
        this.countDownLatch.countDown();
    }

    void onFailure(Throwable throwable) {
        this.throwable = throwable;
        this.countDownLatch.countDown();
    }

    Connection get() throws Throwable {
        this.countDownLatch.await();
        if (this.connection != null) {
            return this.connection;
        }
        assert (this.throwable != null);
        throw new ExecutionException(this.throwable);
    }
}

