/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientNotAllowedInClusterException;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.ClientConnectionStrategy;
import com.hazelcast.client.impl.connection.nio.AuthenticationFuture;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.connection.nio.HeartbeatManager;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.impl.protocol.codec.ClientIsFailoverSupportedCodec;
import com.hazelcast.client.impl.spi.ClientExecutionService;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.ChannelInitializerProvider;
import com.hazelcast.internal.networking.nio.NioNetworking;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.PasswordCredentials;
import com.hazelcast.security.TokenCredentials;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final int DEFAULT_SMART_CLIENT_THREAD_COUNT = 3;
    protected final AtomicInteger connectionIdGen = new AtomicInteger();
    protected volatile boolean alive;
    private final ILogger logger;
    private final int connectionTimeoutMillis;
    private final HazelcastClientInstanceImpl client;
    private final ClientExecutionService executionService;
    private final InetSocketAddressCache inetSocketAddressCache = new InetSocketAddressCache();
    private final ConcurrentMap<InetSocketAddress, ClientConnection> activeConnections = new ConcurrentHashMap<InetSocketAddress, ClientConnection>();
    private final ConcurrentMap<InetSocketAddress, AuthenticationFuture> connectionsInProgress = new ConcurrentHashMap<InetSocketAddress, AuthenticationFuture>();
    private final Collection<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private final NioNetworking networking;
    private final HeartbeatManager heartbeat;
    private final long authenticationTimeout;
    private final ClientConnectionStrategy connectionStrategy;
    private final UUID clientUuid;
    private final LinkedList<Integer> outboundPorts = new LinkedList();
    private final Set<String> labels;
    private final int outboundPortCount;
    private final boolean failoverConfigProvided;
    private volatile Credentials lastCredentials;
    private volatile int clusterPartitionCount = -1;
    private volatile UUID clusterId;
    private volatile CandidateClusterContext currentClusterContext;

    public ClientConnectionManagerImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.labels = Collections.unmodifiableSet(client.getClientConfig().getLabels());
        this.logger = client.getLoggingService().getLogger(ClientConnectionManager.class);
        ClientNetworkConfig networkConfig = client.getClientConfig().getNetworkConfig();
        this.clientUuid = UuidUtil.newUnsecureUUID();
        int connTimeout = networkConfig.getConnectionTimeout();
        this.connectionTimeoutMillis = connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
        this.executionService = client.getClientExecutionService();
        this.networking = this.initNetworking(client);
        this.connectionStrategy = client.getConnectionStrategy();
        this.outboundPorts.addAll(this.getOutboundPorts(networkConfig));
        this.outboundPortCount = this.outboundPorts.size();
        this.heartbeat = new HeartbeatManager(this, client);
        this.authenticationTimeout = this.heartbeat.getHeartbeatTimeout();
        this.failoverConfigProvided = client.getFailoverConfig() != null;
    }

    private Collection<Integer> getOutboundPorts(ClientNetworkConfig networkConfig) {
        Collection<Integer> outboundPorts = networkConfig.getOutboundPorts();
        Collection<String> outboundPortDefinitions = networkConfig.getOutboundPortDefinitions();
        return AddressUtil.getOutboundPorts(outboundPorts, outboundPortDefinitions);
    }

    public NioNetworking getNetworking() {
        return this.networking;
    }

    protected NioNetworking initNetworking(HazelcastClientInstanceImpl client) {
        HazelcastProperties properties = client.getProperties();
        ClientNetworkConfig networkConfig = client.getClientConfig().getNetworkConfig();
        boolean smartClient = networkConfig == null || networkConfig.isSmartRouting();
        int configuredInputThreads = properties.getInteger(ClientProperty.IO_INPUT_THREAD_COUNT);
        int configuredOutputThreads = properties.getInteger(ClientProperty.IO_OUTPUT_THREAD_COUNT);
        int inputThreads = configuredInputThreads == -1 ? (smartClient ? 3 : 1) : configuredInputThreads;
        int outputThreads = configuredOutputThreads == -1 ? (smartClient ? 3 : 1) : configuredOutputThreads;
        return new NioNetworking(new NioNetworking.Context().loggingService(client.getLoggingService()).metricsRegistry(client.getMetricsRegistry()).threadNamePrefix(client.getName()).errorHandler(new ClientConnectionChannelErrorHandler()).inputThreadCount(inputThreads).outputThreadCount(outputThreads).balancerIntervalSeconds(properties.getInteger(ClientProperty.IO_BALANCER_INTERVAL_SECONDS)).writeThroughEnabled(properties.getBoolean(ClientProperty.IO_WRITE_THROUGH_ENABLED)).concurrencyDetection(client.getConcurrencyDetection()));
    }

    public ClientConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    @Override
    public Collection<ClientConnection> getActiveConnections() {
        return this.activeConnections.values();
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    public synchronized void start() {
        if (this.alive) {
            return;
        }
        this.alive = true;
        this.startNetworking();
        this.heartbeat.start();
    }

    protected void startNetworking() {
        this.networking.restart();
    }

    public synchronized void shutdown() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        for (Connection connection : this.activeConnections.values()) {
            connection.close("Hazelcast client is shutting down", null);
        }
        this.stopNetworking();
        this.connectionListeners.clear();
        this.heartbeat.shutdown();
        if (this.currentClusterContext != null) {
            this.currentClusterContext.destroy();
        }
    }

    @Override
    public UUID getClientUuid() {
        return this.clientUuid;
    }

    protected void stopNetworking() {
        this.networking.shutdown();
    }

    @Override
    public Connection getActiveConnection(Address target) {
        if (target == null) {
            return null;
        }
        return (Connection)this.activeConnections.get(this.inetSocketAddressCache.get(target));
    }

    @Override
    public Connection getOrConnect(Address address) throws IOException {
        try {
            ClientConnection connection = (ClientConnection)this.getConnection(address);
            if (connection != null) {
                return connection;
            }
            AuthenticationFuture future = this.triggerConnect(address);
            return future.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Connection getOrTriggerConnect(Address target) throws IOException {
        Connection connection = this.getConnection(target);
        if (connection != null) {
            return connection;
        }
        this.triggerConnect(target);
        return null;
    }

    private Connection getConnection(Address target) throws IOException {
        this.checkAllowed(target);
        if (target == null) {
            throw new IllegalStateException("Address can not be null");
        }
        return (Connection)this.activeConnections.get(this.inetSocketAddressCache.get(target));
    }

    private void checkAllowed(Address target) throws IOException {
        if (!this.alive) {
            throw new HazelcastClientNotActiveException("ConnectionManager is not active!");
        }
        this.connectionStrategy.beforeGetConnection(target);
    }

    private AuthenticationFuture triggerConnect(Address target) {
        this.connectionStrategy.beforeOpenConnection(target);
        AuthenticationFuture future = new AuthenticationFuture();
        AuthenticationFuture oldFuture = this.connectionsInProgress.putIfAbsent(this.inetSocketAddressCache.get(target), future);
        if (oldFuture == null) {
            this.executionService.execute(new InitConnectionTask(target, future));
            return future;
        }
        return oldFuture;
    }

    private void fireConnectionAddedEvent(ClientConnection connection) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionAdded(connection);
        }
        this.connectionStrategy.onConnect(connection);
    }

    private void fireConnectionRemovedEvent(ClientConnection connection) {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connectionRemoved(connection);
        }
        this.connectionStrategy.onDisconnect(connection);
    }

    private boolean useAnyOutboundPort() {
        return this.outboundPortCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireOutboundPort() {
        if (this.outboundPortCount == 0) {
            return 0;
        }
        LinkedList<Integer> linkedList = this.outboundPorts;
        synchronized (linkedList) {
            Integer port = this.outboundPorts.removeFirst();
            this.outboundPorts.addLast(port);
            return port;
        }
    }

    private void bindSocketToPort(Socket socket) throws IOException {
        if (!this.useAnyOutboundPort()) {
            int retryCount = this.outboundPortCount * 2;
            IOException ex = null;
            for (int i = 0; i < retryCount; ++i) {
                int port = this.acquireOutboundPort();
                if (port == 0) {
                    return;
                }
                InetSocketAddress socketAddress = new InetSocketAddress(port);
                try {
                    socket.bind(socketAddress);
                    return;
                }
                catch (IOException e) {
                    ex = e;
                    this.logger.finest("Could not bind port[ " + port + "]: " + e.getMessage());
                    continue;
                }
            }
            throw ex;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(0);
        socket.bind(socketAddress);
    }

    protected ClientConnection createSocketConnection(Address remoteAddress) throws IOException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            this.bindSocketToPort(socket);
            ChannelInitializerProvider channelInitializer = this.currentClusterContext.getChannelInitializerProvider();
            Channel channel = this.networking.register(null, channelInitializer, socketChannel, true);
            channel.connect(this.inetSocketAddressCache.get(remoteAddress), this.connectionTimeoutMillis);
            ClientConnection connection = new ClientConnection(this.client, this.connectionIdGen.incrementAndGet(), channel);
            socketChannel.configureBlocking(true);
            SocketInterceptor socketInterceptor = this.currentClusterContext.getSocketInterceptor();
            if (socketInterceptor != null) {
                socketInterceptor.onConnect(socket);
            }
            channel.start();
            return connection;
        }
        catch (Exception e) {
            IOUtil.closeResource(socketChannel);
            throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
        }
    }

    void onClose(Connection connection) {
        this.removeFromActiveConnections((ClientConnection)connection);
    }

    private void removeFromActiveConnections(ClientConnection connection) {
        Address endpoint = connection.getEndPoint();
        if (endpoint == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Destroying " + connection + ", but it has end-point set to null -> not removing it from a connection map");
            }
            return;
        }
        if (this.activeConnections.remove(this.inetSocketAddressCache.get(endpoint), connection)) {
            this.logger.info("Removed connection to endpoint: " + endpoint + ", connection: " + connection);
            this.fireConnectionRemovedEvent(connection);
        } else if (this.logger.isFinestEnabled()) {
            this.logger.finest("Destroying a connection, but there is no mapping " + endpoint + " -> " + connection + " in the connection map.");
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public Credentials getLastCredentials() {
        return this.lastCredentials;
    }

    @Override
    public void setCandidateClusterContext(CandidateClusterContext context) {
        if (this.currentClusterContext == null) {
            context.start();
        }
        this.currentClusterContext = context;
    }

    @Override
    public void beforeClusterSwitch(CandidateClusterContext context) {
        for (ClientConnection activeConnection : this.activeConnections.values()) {
            activeConnection.close(null, new TargetDisconnectedException("Closing since client is switching cluster"));
        }
        if (this.currentClusterContext != null) {
            this.currentClusterContext.destroy();
        }
        this.clusterId = null;
        this.inetSocketAddressCache.clear();
        this.currentClusterContext = context;
        this.currentClusterContext.start();
    }

    private static class InetSocketAddressCache {
        private final ConcurrentMap<Address, InetSocketAddress> cache = new ConcurrentHashMap<Address, InetSocketAddress>();

        private InetSocketAddressCache() {
        }

        private InetSocketAddress get(Address target) {
            try {
                InetSocketAddress resolvedAddress = (InetSocketAddress)this.cache.get(target);
                if (resolvedAddress != null) {
                    return resolvedAddress;
                }
                InetSocketAddress newResolvedAddress = new InetSocketAddress(target.getInetAddress(), target.getPort());
                InetSocketAddress prevAddress = this.cache.putIfAbsent(target, newResolvedAddress);
                if (prevAddress != null) {
                    return prevAddress;
                }
                return newResolvedAddress;
            }
            catch (UnknownHostException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }

        public void clear() {
            this.cache.clear();
        }
    }

    private class AuthCallback
    implements BiConsumer<ClientMessage, Throwable> {
        private final ClientConnection connection;
        private final Address target;
        private final AuthenticationFuture future;
        private final ScheduledFuture timeoutTaskFuture;
        private final ClientInvocationFuture isFailoverFuture;

        AuthCallback(ClientConnection connection, Address target, AuthenticationFuture future, ScheduledFuture timeoutTaskFuture, ClientInvocationFuture isFailoverFuture) {
            this.connection = connection;
            this.target = target;
            this.future = future;
            this.timeoutTaskFuture = timeoutTaskFuture;
            this.isFailoverFuture = isFailoverFuture;
        }

        @Override
        public void accept(ClientMessage response, Throwable throwable) {
            if (throwable == null) {
                this.onResponse(response);
            } else {
                this.onFailure(throwable);
            }
        }

        public void onResponse(ClientMessage response) {
            ClientAuthenticationCodec.ResponseParameters result;
            this.timeoutTaskFuture.cancel(true);
            try {
                result = ClientAuthenticationCodec.decodeResponse(response);
            }
            catch (HazelcastException e) {
                this.onFailure(e);
                return;
            }
            AuthenticationStatus authenticationStatus = AuthenticationStatus.getById(result.status);
            switch (authenticationStatus) {
                case AUTHENTICATED: {
                    if (!this.checkFailoverSupportIfNeeded(result)) {
                        return;
                    }
                    this.handleSuccessResult(result);
                    this.onAuthenticated();
                    this.future.onSuccess(this.connection);
                    break;
                }
                case CREDENTIALS_FAILED: {
                    this.onFailure(new AuthenticationException("Invalid credentials!"));
                    break;
                }
                case NOT_ALLOWED_IN_CLUSTER: {
                    this.onFailure(new ClientNotAllowedInClusterException("Client is not allowed in the cluster"));
                    break;
                }
                default: {
                    this.onFailure(new AuthenticationException("Authentication status code not supported. status: " + (Object)((Object)authenticationStatus)));
                }
            }
        }

        private void handleSuccessResult(ClientAuthenticationCodec.ResponseParameters result) {
            ClientConnectionManagerImpl.this.clusterPartitionCount = result.partitionCount;
            ClientConnectionManagerImpl.this.clusterId = result.clusterId;
            this.connection.setConnectedServerVersion(result.serverHazelcastVersion);
            this.connection.setRemoteEndpoint(result.address);
        }

        private boolean checkFailoverSupportIfNeeded(ClientAuthenticationCodec.ResponseParameters result) {
            boolean isFailoverAskedToCluster;
            boolean bl = isFailoverAskedToCluster = this.isFailoverFuture != null;
            if (!isFailoverAskedToCluster) {
                return true;
            }
            if (BuildInfo.calculateVersion(result.serverHazelcastVersion) < BuildInfo.calculateVersion("3.12")) {
                this.onFailure(new ClientNotAllowedInClusterException("Cluster does not support failover. This feature is available in Hazelcast Enterprise with version 3.12 and after"));
                return false;
            }
            try {
                boolean isAllowed = ClientIsFailoverSupportedCodec.decodeResponse((ClientMessage)((ClientMessage)this.isFailoverFuture.get())).response;
                if (!isAllowed) {
                    this.onFailure(new ClientNotAllowedInClusterException("Cluster does not support failover. This feature is available in Hazelcast Enterprise"));
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                this.onFailure(e);
                return false;
            }
        }

        private void onAuthenticated() {
            Address memberAddress = this.connection.getEndPoint();
            ClientConnection oldConnection = ClientConnectionManagerImpl.this.activeConnections.put(ClientConnectionManagerImpl.this.inetSocketAddressCache.get(memberAddress), this.connection);
            if (oldConnection == null) {
                if (ClientConnectionManagerImpl.this.logger.isFinestEnabled()) {
                    ClientConnectionManagerImpl.this.logger.finest("Authentication succeeded for " + this.connection + " and there was no old connection to this end-point");
                }
                ClientConnectionManagerImpl.this.fireConnectionAddedEvent(this.connection);
            } else {
                if (ClientConnectionManagerImpl.this.logger.isFinestEnabled()) {
                    ClientConnectionManagerImpl.this.logger.finest("Re-authentication succeeded for " + this.connection);
                }
                if (!this.connection.equals(oldConnection)) {
                    ClientConnectionManagerImpl.this.logger.severe("The address that client is connected from does not match with the member address.  This setup is illegal and will cause inconsistent behaviour Address that client uses : " + this.target + ", member address : " + memberAddress);
                }
            }
            ClientConnectionManagerImpl.this.connectionsInProgress.remove(ClientConnectionManagerImpl.this.inetSocketAddressCache.get(this.target));
            ClientConnectionManagerImpl.this.logger.info("Authenticated with server " + memberAddress + ", server version:" + this.connection.getConnectedServerVersion() + " Local address: " + this.connection.getLocalSocketAddress());
            if (!this.connection.isAlive()) {
                ClientConnectionManagerImpl.this.removeFromActiveConnections(this.connection);
            }
        }

        public void onFailure(Throwable cause) {
            this.timeoutTaskFuture.cancel(true);
            if (ClientConnectionManagerImpl.this.logger.isFinestEnabled()) {
                ClientConnectionManagerImpl.this.logger.finest("Authentication of " + this.connection + " failed.", cause);
            }
            this.connection.close(null, cause);
            ClientConnectionManagerImpl.this.connectionsInProgress.remove(ClientConnectionManagerImpl.this.inetSocketAddressCache.get(this.target));
            this.future.onFailure(cause);
        }
    }

    private class InitConnectionTask
    implements Runnable {
        private final Address target;
        private final AuthenticationFuture future;

        InitConnectionTask(Address target, AuthenticationFuture future) {
            this.target = target;
            this.future = future;
        }

        @Override
        public void run() {
            ClientConnection connection;
            try {
                connection = this.getConnection();
            }
            catch (Exception e) {
                ClientConnectionManagerImpl.this.logger.finest(e);
                this.future.onFailure(e);
                ClientConnectionManagerImpl.this.connectionsInProgress.remove(ClientConnectionManagerImpl.this.inetSocketAddressCache.get(this.target));
                return;
            }
            try {
                this.authenticateAsync(connection);
            }
            catch (Exception e) {
                this.future.onFailure(e);
                connection.close("Failed to authenticate connection", e);
                ClientConnectionManagerImpl.this.connectionsInProgress.remove(ClientConnectionManagerImpl.this.inetSocketAddressCache.get(this.target));
            }
        }

        private void authenticateAsync(ClientConnection connection) {
            ClientMessage clientMessage = this.encodeAuthenticationRequest();
            ClientInvocation clientInvocation = new ClientInvocation(ClientConnectionManagerImpl.this.client, clientMessage, null, connection);
            ClientInvocationFuture invocationFuture = clientInvocation.invokeUrgent();
            ClientInvocationFuture failoverFuture = null;
            if (ClientConnectionManagerImpl.this.failoverConfigProvided) {
                ClientMessage isFailoverSupportedMessage = ClientIsFailoverSupportedCodec.encodeRequest();
                failoverFuture = new ClientInvocation(ClientConnectionManagerImpl.this.client, isFailoverSupportedMessage, null, connection).invoke();
            }
            ScheduledFuture<?> timeoutTaskFuture = ClientConnectionManagerImpl.this.executionService.schedule(new TimeoutAuthenticationTask(invocationFuture), ClientConnectionManagerImpl.this.authenticationTimeout, TimeUnit.MILLISECONDS);
            AuthCallback callback = new AuthCallback(connection, this.target, this.future, timeoutTaskFuture, failoverFuture);
            invocationFuture.whenCompleteAsync((BiConsumer)callback);
        }

        private ClientMessage encodeAuthenticationRequest() {
            InternalSerializationService ss = ClientConnectionManagerImpl.this.client.getSerializationService();
            byte serializationVersion = ss.getVersion();
            Credentials credentials = ClientConnectionManagerImpl.this.currentClusterContext.getCredentialsFactory().newCredentials();
            ClientConnectionManagerImpl.this.lastCredentials = credentials;
            UUID resolvedClusterId = null;
            if (ClientConnectionManagerImpl.this.failoverConfigProvided) {
                resolvedClusterId = ClientConnectionManagerImpl.this.clusterId;
            }
            if (credentials instanceof PasswordCredentials) {
                PasswordCredentials cr = (PasswordCredentials)credentials;
                return ClientAuthenticationCodec.encodeRequest(cr.getName(), cr.getPassword(), ClientConnectionManagerImpl.this.clientUuid, "JVM", serializationVersion, BuildInfoProvider.getBuildInfo().getVersion(), ClientConnectionManagerImpl.this.client.getName(), ClientConnectionManagerImpl.this.labels, ClientConnectionManagerImpl.this.clusterPartitionCount, resolvedClusterId);
            }
            Object data = credentials instanceof TokenCredentials ? new HeapData(((TokenCredentials)credentials).getToken()) : ss.toData(credentials);
            return ClientAuthenticationCustomCodec.encodeRequest(data, ClientConnectionManagerImpl.this.clientUuid, "JVM", serializationVersion, BuildInfoProvider.getBuildInfo().getVersion(), ClientConnectionManagerImpl.this.client.getName(), ClientConnectionManagerImpl.this.labels, ClientConnectionManagerImpl.this.clusterPartitionCount, resolvedClusterId);
        }

        private ClientConnection getConnection() throws IOException {
            ClientConnection connection = (ClientConnection)ClientConnectionManagerImpl.this.activeConnections.get(ClientConnectionManagerImpl.this.inetSocketAddressCache.get(this.target));
            if (connection != null) {
                return connection;
            }
            AddressProvider addressProvider = ClientConnectionManagerImpl.this.currentClusterContext.getAddressProvider();
            Address address = null;
            try {
                address = addressProvider.translate(this.target);
            }
            catch (Exception e) {
                ClientConnectionManagerImpl.this.logger.warning("Failed to translate address " + this.target + " via address provider " + e.getMessage());
            }
            if (address == null) {
                throw new NullPointerException("Address Provider " + addressProvider.getClass() + " could not translate address " + this.target);
            }
            return ClientConnectionManagerImpl.this.createSocketConnection(address);
        }
    }

    private class ClientConnectionChannelErrorHandler
    implements ChannelErrorHandler {
        private ClientConnectionChannelErrorHandler() {
        }

        @Override
        public void onError(Channel channel, Throwable cause) {
            if (channel == null) {
                ClientConnectionManagerImpl.this.logger.severe(cause);
            } else {
                if (cause instanceof OutOfMemoryError) {
                    ClientConnectionManagerImpl.this.logger.severe(cause);
                }
                Connection connection = (Connection)channel.attributeMap().get(ClientConnection.class);
                if (cause instanceof EOFException) {
                    connection.close("Connection closed by the other side", cause);
                } else {
                    connection.close("Exception in " + connection + ", thread=" + Thread.currentThread().getName(), cause);
                }
            }
        }
    }

    private class TimeoutAuthenticationTask
    implements Runnable {
        private final ClientInvocationFuture future;

        TimeoutAuthenticationTask(ClientInvocationFuture future) {
            this.future = future;
        }

        @Override
        public void run() {
            if (this.future.isDone()) {
                return;
            }
            this.future.complete(new TimeoutException("Authentication response did not come back in " + ClientConnectionManagerImpl.this.authenticationTimeout + " millis"));
        }
    }
}

