/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.nio;

import com.hazelcast.client.ClientNotAllowedInClusterException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.ClientDiscoveryService;
import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.LifecycleServiceImpl;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.Addresses;
import com.hazelcast.client.impl.connection.ClientConnectionStrategy;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.connection.nio.ClusterConnectorService;
import com.hazelcast.client.impl.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.executor.SingleExecutorThreadFactory;
import com.hazelcast.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ClusterConnectorServiceImpl
implements ClusterConnectorService,
ConnectionListener {
    private final ILogger logger;
    private final HazelcastClientInstanceImpl client;
    private final ClientConnectionManagerImpl connectionManager;
    private final ClientConnectionStrategy connectionStrategy;
    private final ExecutorService clusterConnectionExecutor;
    private final boolean shuffleMemberList;
    private final WaitStrategy waitStrategy;
    private final ClientDiscoveryService discoveryService;
    private volatile ClientConnection clusterListeningConnection;

    public ClusterConnectorServiceImpl(HazelcastClientInstanceImpl client, ClientConnectionManagerImpl connectionManager, ClientConnectionStrategy connectionStrategy, ClientDiscoveryService discoveryService) {
        this.client = client;
        this.connectionManager = connectionManager;
        this.logger = client.getLoggingService().getLogger(ClusterConnectorService.class);
        this.connectionStrategy = connectionStrategy;
        this.clusterConnectionExecutor = this.createSingleThreadExecutorService(client);
        this.shuffleMemberList = client.getProperties().getBoolean(ClientProperty.SHUFFLE_MEMBER_LIST);
        this.discoveryService = discoveryService;
        this.waitStrategy = this.initializeWaitStrategy(client.getClientConfig());
    }

    private WaitStrategy initializeWaitStrategy(ClientConfig clientConfig) {
        ClientConnectionStrategyConfig connectionStrategyConfig = clientConfig.getConnectionStrategyConfig();
        ConnectionRetryConfig expoRetryConfig = connectionStrategyConfig.getConnectionRetryConfig();
        return new WaitStrategy(expoRetryConfig.getInitialBackoffMillis(), expoRetryConfig.getMaxBackoffMillis(), expoRetryConfig.getMultiplier(), expoRetryConfig.isFailOnMaxBackoff(), expoRetryConfig.getJitter());
    }

    @Override
    public void connectToCluster() {
        try {
            this.connectToClusterAsync().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean mainConnectionExists() {
        return this.clusterListeningConnection != null;
    }

    @Override
    public ClientConnection getClusterConnection() {
        return this.clusterListeningConnection;
    }

    private void setClusterConnection(ClientConnection connection) {
        this.clusterListeningConnection = connection;
    }

    private Connection connect(Address address) {
        Connection connection = null;
        try {
            this.logger.info("Trying to connect to " + address + " as main member");
            connection = this.connectionManager.getOrConnect(address);
            this.setClusterConnection((ClientConnection)connection);
            this.client.onClusterConnect(connection);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
            this.connectionStrategy.onClusterConnect();
        }
        catch (InvalidConfigurationException e) {
            this.setClusterConnection(null);
            this.logger.warning("Exception during initial connection to " + address + ": " + e);
            if (null != connection) {
                connection.close("Could not connect to " + address + " as owner", e);
            }
            throw ExceptionUtil.rethrow(e);
        }
        catch (ClientNotAllowedInClusterException e) {
            this.setClusterConnection(null);
            this.logger.warning("Exception during initial connection to " + address + ": " + e);
            if (null != connection) {
                connection.close("Could not connect to " + address + " as owner", e);
            }
            throw e;
        }
        catch (Exception e) {
            this.setClusterConnection(null);
            this.logger.warning("Exception during initial connection to " + address + ": " + e);
            if (null != connection) {
                connection.close("Could not connect to " + address + " as owner", e);
            }
            return null;
        }
        return connection;
    }

    private void fireLifecycleEvent(LifecycleEvent.LifecycleState state) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        lifecycleService.fireLifecycleEvent(state);
    }

    private ExecutorService createSingleThreadExecutorService(HazelcastClientInstanceImpl client) {
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        SingleExecutorThreadFactory threadFactory = new SingleExecutorThreadFactory(classLoader, client.getName() + ".cluster-");
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    private void connectToClusterInternal() {
        CandidateClusterContext currentClusterContext = this.discoveryService.current();
        this.logger.info("Trying to connect to cluster with client name: " + currentClusterContext.getClientName());
        if (this.connectToCandidate(currentClusterContext)) {
            return;
        }
        this.discoveryService.resetSearch();
        while (this.discoveryService.hasNext() && this.client.getLifecycleService().isRunning()) {
            CandidateClusterContext candidateClusterContext = this.discoveryService.next();
            this.beforeClusterSwitch(candidateClusterContext);
            this.logger.info("Trying to connect to next cluster with client name: " + candidateClusterContext.getClientName());
            if (!this.connectToCandidate(candidateClusterContext)) continue;
            this.client.getQueryCacheContext().recreateAllCaches();
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CHANGED_CLUSTER);
            return;
        }
        if (!this.client.getLifecycleService().isRunning()) {
            throw new IllegalStateException("Client is being shutdown.");
        }
        throw new IllegalStateException("Unable to connect to any cluster.");
    }

    private void beforeClusterSwitch(CandidateClusterContext context) {
        try {
            this.client.getNearCacheManager().clearAllNearCaches();
        }
        catch (Throwable e) {
            this.logger.warning("Error when clearing near caches before cluster switch ", e);
        }
        this.client.getClientClusterService().reset();
        this.client.getClientPartitionService().reset();
        this.client.getConnectionManager().beforeClusterSwitch(context);
        ((ClientLoggingService)this.client.getLoggingService()).updateClientName(context.getClientName());
    }

    private boolean connectToCandidate(CandidateClusterContext context) {
        HashSet<Address> triedAddresses = new HashSet<Address>();
        this.client.getConnectionManager().setCandidateClusterContext(context);
        this.waitStrategy.reset();
        block2: do {
            Collection<Address> addresses = this.getPossibleMemberAddresses(context.getAddressProvider());
            for (Address address : addresses) {
                if (!this.client.getLifecycleService().isRunning()) {
                    throw new IllegalStateException("Giving up retrying to connect to cluster since client is shutdown.");
                }
                triedAddresses.add(address);
                try {
                    Connection connection = this.connect(address);
                    if (connection == null) continue;
                    return true;
                }
                catch (ClientNotAllowedInClusterException e) {
                    break block2;
                }
            }
            if (this.client.getLifecycleService().isRunning()) continue;
            throw new IllegalStateException("Client is being shutdown.");
        } while (this.waitStrategy.sleep());
        this.logger.warning("Unable to connect to any address for client name: " + context.getClientName() + ". The following addresses were tried: " + triedAddresses);
        return false;
    }

    @Override
    public Future<Void> connectToClusterAsync() {
        return this.clusterConnectionExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    ClusterConnectorServiceImpl.this.connectToClusterInternal();
                }
                catch (Throwable e) {
                    ClusterConnectorServiceImpl.this.logger.warning("Could not connect to any cluster, shutting down the client: " + e.getMessage());
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ClusterConnectorServiceImpl.this.client.getLifecycleService().shutdown();
                            }
                            catch (Exception exception) {
                                ClusterConnectorServiceImpl.this.logger.severe("Exception during client shutdown", exception);
                            }
                        }
                    }, ClusterConnectorServiceImpl.this.client.getName() + ".clientShutdown-").start();
                    throw ExceptionUtil.rethrow(e);
                }
                return null;
            }
        });
    }

    Collection<Address> getPossibleMemberAddresses(AddressProvider addressProvider) {
        LinkedHashSet addresses = new LinkedHashSet();
        Collection<Member> memberList = this.client.getClientClusterService().getMemberList();
        for (Member member : memberList) {
            addresses.add(member.getAddress());
        }
        if (this.shuffleMemberList) {
            addresses = (LinkedHashSet)ClusterConnectorServiceImpl.shuffle(addresses);
        }
        LinkedHashSet<Address> providedAddresses = new LinkedHashSet<Address>();
        try {
            Addresses result = addressProvider.loadAddresses();
            if (this.shuffleMemberList) {
                Collections.shuffle(result.primary());
                Collections.shuffle(result.secondary());
            }
            providedAddresses.addAll(result.primary());
            providedAddresses.addAll(result.secondary());
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.warning("Exception from AddressProvider: " + this.discoveryService, e);
        }
        addresses.addAll(providedAddresses);
        if (this.clusterListeningConnection != null) {
            Address endPoint = this.clusterListeningConnection.getEndPoint();
            addresses.remove(endPoint);
            addresses.add(endPoint);
        }
        return addresses;
    }

    private static <T> Set<T> shuffle(Set<T> set) {
        ArrayList<T> shuffleMe = new ArrayList<T>(set);
        Collections.shuffle(shuffleMe);
        return new LinkedHashSet<T>(shuffleMe);
    }

    @Override
    public void shutdown() {
        ClientExecutionServiceImpl.shutdownExecutor("cluster", this.clusterConnectionExecutor, this.logger);
    }

    @Override
    public void connectionAdded(Connection connection) {
    }

    @Override
    public void connectionRemoved(Connection connection) {
        final ClientConnection clientConnection = (ClientConnection)connection;
        if (clientConnection == this.clusterListeningConnection) {
            this.clusterConnectionExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (clientConnection != ClusterConnectorServiceImpl.this.clusterListeningConnection) {
                        return;
                    }
                    ClusterConnectorServiceImpl.this.setClusterConnection(null);
                    ClusterConnectorServiceImpl.this.connectionStrategy.onDisconnectFromCluster();
                    ClusterConnectorServiceImpl.this.client.onClusterDisconnect();
                    if (ClusterConnectorServiceImpl.this.client.getLifecycleService().isRunning()) {
                        ClusterConnectorServiceImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
                    }
                }
            });
        }
    }

    class WaitStrategy {
        private final int initialBackoffMillis;
        private final int maxBackoffMillis;
        private final double multiplier;
        private final boolean failOnMaxBackoff;
        private final double jitter;
        private final Random random = new Random();
        private int attempt;
        private int currentBackoffMillis;

        WaitStrategy(int initialBackoffMillis, int maxBackoffMillis, double multiplier, boolean failOnMaxBackoff, double jitter) {
            this.initialBackoffMillis = initialBackoffMillis;
            this.maxBackoffMillis = maxBackoffMillis;
            this.multiplier = multiplier;
            this.failOnMaxBackoff = failOnMaxBackoff;
            this.jitter = jitter;
        }

        public void reset() {
            this.attempt = 0;
            this.currentBackoffMillis = Math.min(this.maxBackoffMillis, this.initialBackoffMillis);
        }

        public boolean sleep() {
            ++this.attempt;
            if (this.failOnMaxBackoff && this.currentBackoffMillis >= this.maxBackoffMillis) {
                ClusterConnectorServiceImpl.this.logger.warning(String.format("Unable to get live cluster connection, attempt %d.", this.attempt));
                return false;
            }
            long actualSleepTime = (long)((double)this.currentBackoffMillis - (double)this.currentBackoffMillis * this.jitter + (double)this.currentBackoffMillis * this.jitter * this.random.nextDouble());
            ClusterConnectorServiceImpl.this.logger.warning(String.format("Unable to get live cluster connection, retry in %d ms, attempt %d, retry timeout millis %d cap", actualSleepTime, this.attempt, this.maxBackoffMillis));
            try {
                Thread.sleep(actualSleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            this.currentBackoffMillis = (int)Math.min((double)this.currentBackoffMillis * this.multiplier, (double)this.maxBackoffMillis);
            return true;
        }
    }
}

