/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.nio;

import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.impl.connection.ClientConnectionStrategy;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.connection.nio.ClusterConnectorService;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.cluster.Address;
import java.util.concurrent.RejectedExecutionException;

public class DefaultClientConnectionStrategy
extends ClientConnectionStrategy {
    private boolean asyncStart;
    private ClientConnectionStrategyConfig.ReconnectMode reconnectMode;
    private ClusterConnectorService clusterConnectorService;

    @Override
    public void init(ClientContext clientContext) {
        super.init(clientContext);
        this.clusterConnectorService = clientContext.getClusterConnectorService();
        this.asyncStart = this.clientConnectionStrategyConfig.isAsyncStart();
        this.reconnectMode = this.clientConnectionStrategyConfig.getReconnectMode();
    }

    @Override
    public void start() {
        if (this.asyncStart) {
            this.clusterConnectorService.connectToClusterAsync();
        } else {
            this.clusterConnectorService.connectToCluster();
        }
    }

    @Override
    public void beforeGetConnection(Address target) {
    }

    @Override
    public void beforeOpenConnection(Address target) {
    }

    @Override
    public void onClusterConnect() {
    }

    @Override
    public void onDisconnectFromCluster() {
        if (this.reconnectMode == ClientConnectionStrategyConfig.ReconnectMode.OFF) {
            this.shutdownWithExternalThread();
            return;
        }
        if (this.clientContext.getLifecycleService().isRunning()) {
            try {
                this.clusterConnectorService.connectToClusterAsync();
            }
            catch (RejectedExecutionException r) {
                this.shutdownWithExternalThread();
            }
        }
    }

    private void shutdownWithExternalThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultClientConnectionStrategy.this.clientContext.getLifecycleService().shutdown();
                }
                catch (Exception exception) {
                    DefaultClientConnectionStrategy.this.logger.severe("Exception during client shutdown ", exception);
                }
            }
        }, this.clientContext.getName() + ".clientShutdown-").start();
    }

    @Override
    public void onConnect(ClientConnection connection) {
    }

    @Override
    public void onDisconnect(ClientConnection connection) {
    }

    @Override
    public void shutdown() {
    }
}

