/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.BinaryInterface;
import java.util.Arrays;
import java.util.Objects;

@BinaryInterface
public final class ClientMessage
implements OutboundFrame {
    public static final int TYPE_FIELD_OFFSET = 0;
    public static final int CORRELATION_ID_FIELD_OFFSET = 4;
    public static final int RESPONSE_BACKUP_ACKS_FIELD_OFFSET = 12;
    public static final int PARTITION_ID_FIELD_OFFSET = 12;
    public static final int FRAGMENTATION_ID_OFFSET = 0;
    public static final int DEFAULT_FLAGS = 0;
    public static final int BEGIN_FRAGMENT_FLAG = 32768;
    public static final int END_FRAGMENT_FLAG = 16384;
    public static final int UNFRAGMENTED_MESSAGE = 49152;
    public static final int IS_FINAL_FLAG = 8192;
    public static final int BEGIN_DATA_STRUCTURE_FLAG = 4096;
    public static final int END_DATA_STRUCTURE_FLAG = 2048;
    public static final int IS_NULL_FLAG = 1024;
    public static final int IS_EVENT_FLAG = 512;
    public static final int BACKUP_AWARE_FLAG = 256;
    public static final int BACKUP_EVENT_FLAG = 128;
    public static final int SIZE_OF_FRAME_LENGTH_AND_FLAGS = 6;
    public static final Frame NULL_FRAME = new Frame(new byte[0], 1024);
    public static final Frame BEGIN_FRAME = new Frame(new byte[0], 4096);
    public static final Frame END_FRAME = new Frame(new byte[0], 2048);
    private static final long serialVersionUID = 1L;
    transient Frame startFrame;
    transient Frame endFrame;
    private transient boolean isRetryable;
    private transient boolean acquiresResource;
    private transient String operationName;
    private transient Connection connection;

    private ClientMessage() {
    }

    private ClientMessage(Frame startFrame) {
        this.startFrame = startFrame;
        this.endFrame = startFrame;
        while (this.endFrame.next != null) {
            this.endFrame = this.endFrame.next;
        }
    }

    public static ClientMessage createForEncode() {
        return new ClientMessage();
    }

    public static ClientMessage createForDecode(Frame startFrame) {
        return new ClientMessage(startFrame);
    }

    public Frame getStartFrame() {
        return this.startFrame;
    }

    public ClientMessage add(Frame frame) {
        frame.next = null;
        if (this.startFrame == null) {
            this.startFrame = frame;
            this.endFrame = frame;
            return this;
        }
        this.endFrame.next = frame;
        this.endFrame = frame;
        return this;
    }

    public ForwardFrameIterator frameIterator() {
        return new ForwardFrameIterator(this.startFrame);
    }

    public int getMessageType() {
        return Bits.readIntL(this.startFrame.content, 0);
    }

    public ClientMessage setMessageType(int messageType) {
        Bits.writeIntL(this.startFrame.content, 0, messageType);
        return this;
    }

    public long getCorrelationId() {
        return Bits.readLongL(this.startFrame.content, 4);
    }

    public ClientMessage setCorrelationId(long correlationId) {
        Bits.writeLongL(this.startFrame.content, 4, correlationId);
        return this;
    }

    public int getNumberOfBackupAcks() {
        return Bits.readIntL(this.getStartFrame().content, 12);
    }

    public ClientMessage setNumberOfBackupAcks(int numberOfAcks) {
        Bits.writeIntL(this.getStartFrame().content, 12, numberOfAcks);
        return this;
    }

    public int getPartitionId() {
        return Bits.readIntL(this.startFrame.content, 12);
    }

    public ClientMessage setPartitionId(int partitionId) {
        Bits.writeIntL(this.startFrame.content, 12, partitionId);
        return this;
    }

    public int getHeaderFlags() {
        return this.startFrame.flags;
    }

    public boolean isRetryable() {
        return this.isRetryable;
    }

    public boolean acquiresResource() {
        return this.acquiresResource;
    }

    public void setAcquiresResource(boolean acquiresResource) {
        this.acquiresResource = acquiresResource;
    }

    public void setRetryable(boolean isRetryable) {
        this.isRetryable = isRetryable;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public static boolean isFlagSet(int flags, int flagMask) {
        int i = flags & flagMask;
        return i == flagMask;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFrameLength() {
        int frameLength = 0;
        Frame currentFrame = this.startFrame;
        while (currentFrame != null) {
            frameLength += currentFrame.getSize();
            currentFrame = currentFrame.next;
        }
        return frameLength;
    }

    @Override
    public boolean isUrgent() {
        return false;
    }

    public void merge(ClientMessage fragment) {
        Frame fragmentMessageStartFrame;
        this.endFrame.next = fragmentMessageStartFrame = fragment.startFrame.next;
        while (this.endFrame.next != null) {
            this.endFrame = this.endFrame.next;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientMessage{");
        sb.append("connection=").append(this.connection);
        if (this.startFrame != null) {
            sb.append(", length=").append(this.getFrameLength());
            sb.append(", correlationId=").append(this.getCorrelationId());
            sb.append(", operation=").append(this.getOperationName());
            sb.append(", messageType=").append(Integer.toHexString(this.getMessageType()));
            sb.append(", isRetryable=").append(this.isRetryable());
            sb.append(", isEvent=").append(ClientMessage.isFlagSet(this.startFrame.flags, 512));
            sb.append(", isFragmented=").append(!ClientMessage.isFlagSet(this.startFrame.flags, 49152));
        }
        sb.append('}');
        return sb.toString();
    }

    public ClientMessage copyWithNewCorrelationId(long correlationId) {
        Frame initialFrameCopy = this.startFrame.deepCopy();
        ClientMessage newMessage = new ClientMessage(initialFrameCopy);
        newMessage.setCorrelationId(correlationId);
        newMessage.isRetryable = this.isRetryable;
        newMessage.acquiresResource = this.acquiresResource;
        newMessage.operationName = this.operationName;
        return newMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientMessage message = (ClientMessage)o;
        if (this.isRetryable != message.isRetryable) {
            return false;
        }
        if (this.acquiresResource != message.acquiresResource) {
            return false;
        }
        if (!Objects.equals(this.operationName, message.operationName)) {
            return false;
        }
        return Objects.equals(this.connection, message.connection);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isRetryable ? 1 : 0);
        result = 31 * result + (this.acquiresResource ? 1 : 0);
        result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
        result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
        return result;
    }

    public static class Frame {
        public final byte[] content;
        public int flags;
        Frame next;

        public Frame(byte[] content) {
            this(content, 0);
        }

        public Frame(byte[] content, int flags) {
            assert (content != null);
            this.content = content;
            this.flags = flags;
        }

        public Frame copy() {
            Frame frame = new Frame(this.content, this.flags);
            frame.next = this.next;
            return frame;
        }

        public Frame deepCopy() {
            byte[] newContent = Arrays.copyOf(this.content, this.content.length);
            Frame frame = new Frame(newContent, this.flags);
            frame.next = this.next;
            return frame;
        }

        public boolean isEndFrame() {
            return ClientMessage.isFlagSet(this.flags, 2048);
        }

        public boolean isBeginFrame() {
            return ClientMessage.isFlagSet(this.flags, 4096);
        }

        public boolean isNullFrame() {
            return ClientMessage.isFlagSet(this.flags, 1024);
        }

        public int getSize() {
            if (this.content == null) {
                return 6;
            }
            return 6 + this.content.length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frame frame = (Frame)o;
            if (this.flags != frame.flags) {
                return false;
            }
            return Arrays.equals(this.content, frame.content);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.content);
            result = 31 * result + this.flags;
            return result;
        }
    }

    public static final class ForwardFrameIterator {
        private Frame nextFrame;

        private ForwardFrameIterator(Frame start) {
            this.nextFrame = start;
        }

        public Frame next() {
            Frame result = this.nextFrame;
            if (this.nextFrame != null) {
                this.nextFrame = this.nextFrame.next;
            }
            return result;
        }

        public boolean hasNext() {
            return this.nextFrame != null;
        }

        public Frame peekNext() {
            return this.nextFrame;
        }
    }
}

