/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.RaftGroupIdCodec;
import com.hazelcast.cp.internal.RaftGroupId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class CPSessionCreateSessionCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x220100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x220101;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_SESSION_ID_FIELD_OFFSET = 16;
    private static final int RESPONSE_TTL_MILLIS_FIELD_OFFSET = 24;
    private static final int RESPONSE_HEARTBEAT_MILLIS_FIELD_OFFSET = 32;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 40;

    private CPSessionCreateSessionCodec() {
    }

    public static ClientMessage encodeRequest(RaftGroupId groupId, String endpointName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("CPSession.CreateSession");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x220100);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        StringCodec.encode(clientMessage, endpointName);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.groupId = RaftGroupIdCodec.decode(iterator);
        request.endpointName = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(long sessionId, long ttlMillis, long heartbeatMillis) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[40], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x220101);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, sessionId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, ttlMillis);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, heartbeatMillis);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.sessionId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        response.ttlMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        response.heartbeatMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long sessionId;
        public long ttlMillis;
        public long heartbeatMillis;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public RaftGroupId groupId;
        public String endpointName;
    }
}

