/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.CacheEventDataCodec;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public final class CacheAddEntryListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x150100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x150101;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 33;
    private static final int EVENT_CACHE_TYPE_FIELD_OFFSET = 16;
    private static final int EVENT_CACHE_COMPLETION_ID_FIELD_OFFSET = 20;
    private static final int EVENT_CACHE_INITIAL_FRAME_SIZE = 24;
    private static final int EVENT_CACHE_MESSAGE_TYPE = 1376514;

    private CacheAddEntryListenerCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Cache.AddEntryListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x150100);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x150101);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return response;
    }

    public static ClientMessage encodeCacheEvent(int type, Collection<CacheEventData> keys, int completionId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1376514);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, type);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, completionId);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, keys, CacheEventDataCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 1376514) {
                ClientMessage.Frame initialFrame = iterator.next();
                int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                int completionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
                List<CacheEventData> keys = ListMultiFrameCodec.decode(iterator, CacheEventDataCodec::decode);
                this.handleCacheEvent(type, keys, completionId);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleCacheEvent(int var1, Collection<CacheEventData> var2, int var3);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean localOnly;
    }
}

