/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.CacheConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.holder.CacheConfigHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class CacheCreateConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1378048;
    public static final int RESPONSE_MESSAGE_TYPE = 1378049;
    private static final int REQUEST_CREATE_ALSO_ON_OTHERS_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private CacheCreateConfigCodec() {
    }

    public static ClientMessage encodeRequest(CacheConfigHolder cacheConfig, boolean createAlsoOnOthers) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Cache.CreateConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1378048);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, createAlsoOnOthers);
        clientMessage.add(initialFrame);
        CacheConfigHolderCodec.encode(clientMessage, cacheConfig);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.createAlsoOnOthers = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.cacheConfig = CacheConfigHolderCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(CacheConfigHolder response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1378049);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, response, CacheConfigHolderCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        response.response = CodecUtil.decodeNullable(iterator, CacheConfigHolderCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public CacheConfigHolder response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public CacheConfigHolder cacheConfig;
        public boolean createAlsoOnOthers;
    }
}

