/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemberCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public final class ClientAddMembershipListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1024;
    public static final int RESPONSE_MESSAGE_TYPE = 1025;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 33;
    private static final int EVENT_MEMBER_EVENT_TYPE_FIELD_OFFSET = 16;
    private static final int EVENT_MEMBER_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_MEMBER_MESSAGE_TYPE = 1026;
    private static final int EVENT_MEMBER_LIST_INITIAL_FRAME_SIZE = 16;
    private static final int EVENT_MEMBER_LIST_MESSAGE_TYPE = 1027;
    private static final int EVENT_MEMBER_ATTRIBUTE_CHANGE_OPERATION_TYPE_FIELD_OFFSET = 16;
    private static final int EVENT_MEMBER_ATTRIBUTE_CHANGE_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_MEMBER_ATTRIBUTE_CHANGE_MESSAGE_TYPE = 1028;

    private ClientAddMembershipListenerCodec() {
    }

    public static ClientMessage encodeRequest(boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Client.AddMembershipListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1024);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1025);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return response;
    }

    public static ClientMessage encodeMemberEvent(Member member, int eventType) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1026);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, eventType);
        clientMessage.add(initialFrame);
        MemberCodec.encode(clientMessage, member);
        return clientMessage;
    }

    public static ClientMessage encodeMemberListEvent(Collection<Member> members) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1027);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, members, MemberCodec::encode);
        return clientMessage;
    }

    public static ClientMessage encodeMemberAttributeChangeEvent(Member member, Collection<Member> members, String key, int operationType, String value) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1028);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, operationType);
        clientMessage.add(initialFrame);
        MemberCodec.encode(clientMessage, member);
        ListMultiFrameCodec.encode(clientMessage, members, MemberCodec::encode);
        StringCodec.encode(clientMessage, key);
        CodecUtil.encodeNullable(clientMessage, value, StringCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 1026) {
                ClientMessage.Frame initialFrame = iterator.next();
                int eventType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                MemberImpl member = MemberCodec.decode(iterator);
                this.handleMemberEvent(member, eventType);
                return;
            }
            if (messageType == 1027) {
                iterator.next();
                List<Member> members = ListMultiFrameCodec.decode(iterator, MemberCodec::decode);
                this.handleMemberListEvent(members);
                return;
            }
            if (messageType == 1028) {
                ClientMessage.Frame initialFrame = iterator.next();
                int operationType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                MemberImpl member = MemberCodec.decode(iterator);
                List<Member> members = ListMultiFrameCodec.decode(iterator, MemberCodec::decode);
                String key = StringCodec.decode(iterator);
                String value = CodecUtil.decodeNullable(iterator, StringCodec::decode);
                this.handleMemberAttributeChangeEvent(member, members, key, operationType, value);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleMemberEvent(Member var1, int var2);

        public abstract void handleMemberListEvent(Collection<Member> var1);

        public abstract void handleMemberAttributeChangeEvent(Member var1, Collection<Member> var2, String var3, int var4, String var5);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public boolean localOnly;
    }
}

