/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public final class ClientAuthenticationCodec {
    public static final int REQUEST_MESSAGE_TYPE = 512;
    public static final int RESPONSE_MESSAGE_TYPE = 513;
    private static final int REQUEST_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_SERIALIZATION_VERSION_FIELD_OFFSET = 33;
    private static final int REQUEST_PARTITION_COUNT_FIELD_OFFSET = 34;
    private static final int REQUEST_CLUSTER_ID_FIELD_OFFSET = 38;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 55;
    private static final int RESPONSE_STATUS_FIELD_OFFSET = 16;
    private static final int RESPONSE_UUID_FIELD_OFFSET = 17;
    private static final int RESPONSE_SERIALIZATION_VERSION_FIELD_OFFSET = 34;
    private static final int RESPONSE_PARTITION_COUNT_FIELD_OFFSET = 35;
    private static final int RESPONSE_CLUSTER_ID_FIELD_OFFSET = 39;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 56;

    private ClientAuthenticationCodec() {
    }

    public static ClientMessage encodeRequest(String username, String password, UUID uuid, String clientType, byte serializationVersion, String clientHazelcastVersion, String clientName, Collection<String> labels, int partitionCount, UUID clusterId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Client.Authentication");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[55], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 512);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, uuid);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 33, serializationVersion);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 34, partitionCount);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 38, clusterId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, username);
        StringCodec.encode(clientMessage, password);
        StringCodec.encode(clientMessage, clientType);
        StringCodec.encode(clientMessage, clientHazelcastVersion);
        StringCodec.encode(clientMessage, clientName);
        ListMultiFrameCodec.encode(clientMessage, labels, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.serializationVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 33);
        request.partitionCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 34);
        request.clusterId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 38);
        request.username = StringCodec.decode(iterator);
        request.password = StringCodec.decode(iterator);
        request.clientType = StringCodec.decode(iterator);
        request.clientHazelcastVersion = StringCodec.decode(iterator);
        request.clientName = StringCodec.decode(iterator);
        request.labels = ListMultiFrameCodec.decode(iterator, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(byte status, Address address, UUID uuid, byte serializationVersion, String serverHazelcastVersion, int partitionCount, UUID clusterId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[56], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 513);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 16, status);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 17, uuid);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 34, serializationVersion);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 35, partitionCount);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 39, clusterId);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, address, AddressCodec::encode);
        StringCodec.encode(clientMessage, serverHazelcastVersion);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.status = FixedSizeTypesCodec.decodeByte(initialFrame.content, 16);
        response.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 17);
        response.serializationVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 34);
        response.partitionCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 35);
        response.clusterId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 39);
        response.address = CodecUtil.decodeNullable(iterator, AddressCodec::decode);
        response.serverHazelcastVersion = StringCodec.decode(iterator);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public byte status;
        public Address address;
        public UUID uuid;
        public byte serializationVersion;
        public String serverHazelcastVersion;
        public int partitionCount;
        public UUID clusterId;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String username;
        public String password;
        public UUID uuid;
        public String clientType;
        public byte serializationVersion;
        public String clientHazelcastVersion;
        public String clientName;
        public List<String> labels;
        public int partitionCount;
        public UUID clusterId;
    }
}

