/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class ClientPingCodec {
    public static final int REQUEST_MESSAGE_TYPE = 3840;
    public static final int RESPONSE_MESSAGE_TYPE = 3841;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private ClientPingCodec() {
    }

    public static ClientMessage encodeRequest() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Client.Ping");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 3840);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 3841);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
    }
}

