/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ContinuousQueryPublisherCreateWithValueCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x180100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x180101;
    private static final int REQUEST_BATCH_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_BUFFER_SIZE_FIELD_OFFSET = 20;
    private static final int REQUEST_DELAY_SECONDS_FIELD_OFFSET = 24;
    private static final int REQUEST_POPULATE_FIELD_OFFSET = 32;
    private static final int REQUEST_COALESCE_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 34;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private ContinuousQueryPublisherCreateWithValueCodec() {
    }

    public static ClientMessage encodeRequest(String mapName, String cacheName, Data predicate, int batchSize, int bufferSize, long delaySeconds, boolean populate, boolean coalesce) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("ContinuousQuery.PublisherCreateWithValue");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[34], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x180100);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, batchSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, bufferSize);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, delaySeconds);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 32, populate);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 33, coalesce);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mapName);
        StringCodec.encode(clientMessage, cacheName);
        DataCodec.encode(clientMessage, predicate);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.bufferSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.delaySeconds = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        request.populate = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 32);
        request.coalesce = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 33);
        request.mapName = StringCodec.decode(iterator);
        request.cacheName = StringCodec.decode(iterator);
        request.predicate = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(Collection<Map.Entry<Data, Data>> response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x180101);
        clientMessage.add(initialFrame);
        EntryListCodec.encode(clientMessage, response, DataCodec::encode, DataCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        response.response = EntryListCodec.decode(iterator, DataCodec::decode, DataCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public List<Map.Entry<Data, Data>> response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String mapName;
        public String cacheName;
        public Data predicate;
        public int batchSize;
        public int bufferSize;
        public long delaySeconds;
        public boolean populate;
        public boolean coalesce;
    }
}

