/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.CacheSimpleEntryListenerConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EventJournalConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EvictionConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.HotRestartConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.TimedExpiryPolicyFactoryConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanReplicationRefCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.WanReplicationRef;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;

public final class DynamicConfigAddCacheConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x1E1000;
    public static final int RESPONSE_MESSAGE_TYPE = 0x1E1001;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 16;
    private static final int REQUEST_MANAGEMENT_ENABLED_FIELD_OFFSET = 17;
    private static final int REQUEST_READ_THROUGH_FIELD_OFFSET = 18;
    private static final int REQUEST_WRITE_THROUGH_FIELD_OFFSET = 19;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 24;
    private static final int REQUEST_DISABLE_PER_ENTRY_INVALIDATION_EVENTS_FIELD_OFFSET = 28;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 29;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private DynamicConfigAddCacheConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, String keyType, String valueType, boolean statisticsEnabled, boolean managementEnabled, boolean readThrough, boolean writeThrough, String cacheLoaderFactory, String cacheWriterFactory, String cacheLoader, String cacheWriter, int backupCount, int asyncBackupCount, String inMemoryFormat, String splitBrainProtectionName, String mergePolicy, boolean disablePerEntryInvalidationEvents, Collection<ListenerConfigHolder> partitionLostListenerConfigs, String expiryPolicyFactoryClassName, CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig, Collection<CacheSimpleEntryListenerConfig> cacheEntryListeners, EvictionConfigHolder evictionConfig, WanReplicationRef wanReplicationRef, EventJournalConfig eventJournalConfig, HotRestartConfig hotRestartConfig) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("DynamicConfig.AddCacheConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[29], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1E1000);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, statisticsEnabled);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, managementEnabled);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 18, readThrough);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 19, writeThrough);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, asyncBackupCount);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 28, disablePerEntryInvalidationEvents);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, keyType, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, valueType, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheLoaderFactory, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheWriterFactory, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheLoader, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheWriter, StringCodec::encode);
        StringCodec.encode(clientMessage, inMemoryFormat);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mergePolicy, StringCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, partitionLostListenerConfigs, ListenerConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, expiryPolicyFactoryClassName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, timedExpiryPolicyFactoryConfig, TimedExpiryPolicyFactoryConfigCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, cacheEntryListeners, CacheSimpleEntryListenerConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, evictionConfig, EvictionConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, wanReplicationRef, WanReplicationRefCodec::encode);
        CodecUtil.encodeNullable(clientMessage, eventJournalConfig, EventJournalConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, hotRestartConfig, HotRestartConfigCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.managementEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        request.readThrough = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 18);
        request.writeThrough = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 19);
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.disablePerEntryInvalidationEvents = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 28);
        request.name = StringCodec.decode(iterator);
        request.keyType = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.valueType = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.cacheLoaderFactory = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.cacheWriterFactory = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.cacheLoader = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.cacheWriter = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.inMemoryFormat = StringCodec.decode(iterator);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mergePolicy = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.partitionLostListenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        request.expiryPolicyFactoryClassName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.timedExpiryPolicyFactoryConfig = CodecUtil.decodeNullable(iterator, TimedExpiryPolicyFactoryConfigCodec::decode);
        request.cacheEntryListeners = ListMultiFrameCodec.decodeNullable(iterator, CacheSimpleEntryListenerConfigCodec::decode);
        request.evictionConfig = CodecUtil.decodeNullable(iterator, EvictionConfigHolderCodec::decode);
        request.wanReplicationRef = CodecUtil.decodeNullable(iterator, WanReplicationRefCodec::decode);
        request.eventJournalConfig = CodecUtil.decodeNullable(iterator, EventJournalConfigCodec::decode);
        request.hotRestartConfig = CodecUtil.decodeNullable(iterator, HotRestartConfigCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1E1001);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public String keyType;
        public String valueType;
        public boolean statisticsEnabled;
        public boolean managementEnabled;
        public boolean readThrough;
        public boolean writeThrough;
        public String cacheLoaderFactory;
        public String cacheWriterFactory;
        public String cacheLoader;
        public String cacheWriter;
        public int backupCount;
        public int asyncBackupCount;
        public String inMemoryFormat;
        public String splitBrainProtectionName;
        public String mergePolicy;
        public boolean disablePerEntryInvalidationEvents;
        public List<ListenerConfigHolder> partitionLostListenerConfigs;
        public String expiryPolicyFactoryClassName;
        public CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig;
        public List<CacheSimpleEntryListenerConfig> cacheEntryListeners;
        public EvictionConfigHolder evictionConfig;
        public WanReplicationRef wanReplicationRef;
        public EventJournalConfig eventJournalConfig;
        public HotRestartConfig hotRestartConfig;
    }
}

