/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class DynamicConfigAddExecutorConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1968384;
    public static final int RESPONSE_MESSAGE_TYPE = 1968385;
    private static final int REQUEST_POOL_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_QUEUE_CAPACITY_FIELD_OFFSET = 20;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 25;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private DynamicConfigAddExecutorConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int poolSize, int queueCapacity, boolean statisticsEnabled, String splitBrainProtectionName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("DynamicConfig.AddExecutorConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[25], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1968384);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, poolSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, queueCapacity);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 24, statisticsEnabled);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.poolSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.queueCapacity = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 24);
        request.name = StringCodec.decode(iterator);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1968385);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int poolSize;
        public int queueCapacity;
        public boolean statisticsEnabled;
        public String splitBrainProtectionName;
    }
}

