/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AttributeConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EventJournalConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.HotRestartConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.IndexConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MapStoreConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MerkleTreeConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.NearCacheConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.QueryCacheConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanReplicationRefCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.MapStoreConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.NearCacheConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueryCacheConfigHolder;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;

public final class DynamicConfigAddMapConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x1E0E00;
    public static final int RESPONSE_MESSAGE_TYPE = 0x1E0E01;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 16;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 24;
    private static final int REQUEST_MAX_IDLE_SECONDS_FIELD_OFFSET = 28;
    private static final int REQUEST_READ_BACKUP_DATA_FIELD_OFFSET = 32;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 33;
    private static final int REQUEST_MAX_SIZE_CONFIG_SIZE_FIELD_OFFSET = 34;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 38;
    private static final int REQUEST_METADATA_POLICY_FIELD_OFFSET = 42;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 46;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private DynamicConfigAddMapConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int backupCount, int asyncBackupCount, int timeToLiveSeconds, int maxIdleSeconds, String evictionPolicy, boolean readBackupData, String cacheDeserializedValues, String mergePolicy, String inMemoryFormat, Collection<ListenerConfigHolder> listenerConfigs, Collection<ListenerConfigHolder> partitionLostListenerConfigs, boolean statisticsEnabled, String splitBrainProtectionName, Data mapEvictionPolicy, String maxSizeConfigMaxSizePolicy, int maxSizeConfigSize, MapStoreConfigHolder mapStoreConfig, NearCacheConfigHolder nearCacheConfig, WanReplicationRef wanReplicationRef, Collection<IndexConfig> indexConfigs, Collection<AttributeConfig> attributeConfigs, Collection<QueryCacheConfigHolder> queryCacheConfigs, String partitioningStrategyClassName, Data partitioningStrategyImplementation, HotRestartConfig hotRestartConfig, EventJournalConfig eventJournalConfig, MerkleTreeConfig merkleTreeConfig, int mergeBatchSize, int metadataPolicy) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("DynamicConfig.AddMapConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[46], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1E0E00);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, timeToLiveSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, maxIdleSeconds);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 32, readBackupData);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 33, statisticsEnabled);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 34, maxSizeConfigSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 38, mergeBatchSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 42, metadataPolicy);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        StringCodec.encode(clientMessage, evictionPolicy);
        StringCodec.encode(clientMessage, cacheDeserializedValues);
        StringCodec.encode(clientMessage, mergePolicy);
        StringCodec.encode(clientMessage, inMemoryFormat);
        ListMultiFrameCodec.encodeNullable(clientMessage, listenerConfigs, ListenerConfigHolderCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, partitionLostListenerConfigs, ListenerConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mapEvictionPolicy, DataCodec::encode);
        StringCodec.encode(clientMessage, maxSizeConfigMaxSizePolicy);
        CodecUtil.encodeNullable(clientMessage, mapStoreConfig, MapStoreConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, nearCacheConfig, NearCacheConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, wanReplicationRef, WanReplicationRefCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, indexConfigs, IndexConfigCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, attributeConfigs, AttributeConfigCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, queryCacheConfigs, QueryCacheConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, partitioningStrategyClassName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, partitioningStrategyImplementation, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, hotRestartConfig, HotRestartConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, eventJournalConfig, EventJournalConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, merkleTreeConfig, MerkleTreeConfigCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.maxIdleSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.readBackupData = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 32);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 33);
        request.maxSizeConfigSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 34);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 38);
        request.metadataPolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 42);
        request.name = StringCodec.decode(iterator);
        request.evictionPolicy = StringCodec.decode(iterator);
        request.cacheDeserializedValues = StringCodec.decode(iterator);
        request.mergePolicy = StringCodec.decode(iterator);
        request.inMemoryFormat = StringCodec.decode(iterator);
        request.listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        request.partitionLostListenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mapEvictionPolicy = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        request.maxSizeConfigMaxSizePolicy = StringCodec.decode(iterator);
        request.mapStoreConfig = CodecUtil.decodeNullable(iterator, MapStoreConfigHolderCodec::decode);
        request.nearCacheConfig = CodecUtil.decodeNullable(iterator, NearCacheConfigHolderCodec::decode);
        request.wanReplicationRef = CodecUtil.decodeNullable(iterator, WanReplicationRefCodec::decode);
        request.indexConfigs = ListMultiFrameCodec.decodeNullable(iterator, IndexConfigCodec::decode);
        request.attributeConfigs = ListMultiFrameCodec.decodeNullable(iterator, AttributeConfigCodec::decode);
        request.queryCacheConfigs = ListMultiFrameCodec.decodeNullable(iterator, QueryCacheConfigHolderCodec::decode);
        request.partitioningStrategyClassName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.partitioningStrategyImplementation = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        request.hotRestartConfig = CodecUtil.decodeNullable(iterator, HotRestartConfigCodec::decode);
        request.eventJournalConfig = CodecUtil.decodeNullable(iterator, EventJournalConfigCodec::decode);
        request.merkleTreeConfig = CodecUtil.decodeNullable(iterator, MerkleTreeConfigCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1E0E01);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int backupCount;
        public int asyncBackupCount;
        public int timeToLiveSeconds;
        public int maxIdleSeconds;
        public String evictionPolicy;
        public boolean readBackupData;
        public String cacheDeserializedValues;
        public String mergePolicy;
        public String inMemoryFormat;
        public List<ListenerConfigHolder> listenerConfigs;
        public List<ListenerConfigHolder> partitionLostListenerConfigs;
        public boolean statisticsEnabled;
        public String splitBrainProtectionName;
        public Data mapEvictionPolicy;
        public String maxSizeConfigMaxSizePolicy;
        public int maxSizeConfigSize;
        public MapStoreConfigHolder mapStoreConfig;
        public NearCacheConfigHolder nearCacheConfig;
        public WanReplicationRef wanReplicationRef;
        public List<IndexConfig> indexConfigs;
        public List<AttributeConfig> attributeConfigs;
        public List<QueryCacheConfigHolder> queryCacheConfigs;
        public String partitioningStrategyClassName;
        public Data partitioningStrategyImplementation;
        public HotRestartConfig hotRestartConfig;
        public EventJournalConfig eventJournalConfig;
        public MerkleTreeConfig merkleTreeConfig;
        public int mergeBatchSize;
        public int metadataPolicy;
    }
}

